package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationSubmission;
import odata.msgraph.client.beta.entity.collection.request.EducationOutcomeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionResourceCollectionRequest;

@JsonIgnoreType
public class EducationSubmissionRequest extends EntityRequest<EducationSubmission> {

    public EducationSubmissionRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationSubmission.class, contextPath, value, false);
    }

    public EducationOutcomeRequest outcomes(String id) {
        return new EducationOutcomeRequest(contextPath.addSegment("outcomes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationOutcomeCollectionRequest outcomes() {
        return new EducationOutcomeCollectionRequest(
                        contextPath.addSegment("outcomes"), Optional.empty());
    }

    public EducationSubmissionResourceRequest resources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionResourceCollectionRequest resources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("resources"), Optional.empty());
    }

    public EducationSubmissionResourceRequest submittedResources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("submittedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSubmissionResourceCollectionRequest submittedResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("submittedResources"), Optional.empty());
    }

    @Action(name = "setUpResourcesFolder")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> setUpResourcesFolder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setUpResourcesFolder"), EducationSubmission.class, _parameters);
    }

    @Action(name = "reassign")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> reassign() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reassign"), EducationSubmission.class, _parameters);
    }

    @Action(name = "return")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> return_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.return"), EducationSubmission.class, _parameters);
    }

    @Action(name = "submit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> submit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.submit"), EducationSubmission.class, _parameters);
    }

    @Action(name = "unsubmit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> unsubmit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubmit"), EducationSubmission.class, _parameters);
    }

}
