package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.EducationClass;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;

@JsonIgnoreType
public class EducationClassRequest extends EntityRequest<EducationClass> {

    public EducationClassRequest(ContextPath contextPath, Optional<Object> value) {
        super(EducationClass.class, contextPath, value, false);
    }

    public EducationCategoryRequest assignmentCategories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("assignmentCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationCategoryCollectionRequest assignmentCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("assignmentCategories"), Optional.empty());
    }

    public EducationAssignmentDefaultsRequest assignmentDefaults() {
        return new EducationAssignmentDefaultsRequest(contextPath.addSegment("assignmentDefaults"), Optional.empty());
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public EducationAssignmentSettingsRequest assignmentSettings() {
        return new EducationAssignmentSettingsRequest(contextPath.addSegment("assignmentSettings"), Optional.empty());
    }

    public GroupRequest group() {
        return new GroupRequest(contextPath.addSegment("group"), Optional.empty());
    }

    public EducationUserRequest members(String id) {
        return new EducationUserRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest members() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"), Optional.empty());
    }

    public EducationUserRequest teachers(String id) {
        return new EducationUserRequest(contextPath.addSegment("teachers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EducationUserCollectionRequest teachers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("teachers"), Optional.empty());
    }

}
