package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DirectoryRole;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;

@JsonIgnoreType
public class DirectoryRoleRequest extends EntityRequest<DirectoryRole> {

    public DirectoryRoleRequest(ContextPath contextPath, Optional<Object> value) {
        super(DirectoryRole.class, contextPath, value, false);
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public ScopedRoleMembershipRequest scopedMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedMembers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ScopedRoleMembershipCollectionRequest scopedMembers() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedMembers"), Optional.empty());
    }

}
