package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Dimension;
import odata.msgraph.client.beta.entity.collection.request.DimensionValueCollectionRequest;

@JsonIgnoreType
public class DimensionRequest extends EntityRequest<Dimension> {

    public DimensionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Dimension.class, contextPath, value, false);
    }

    public DimensionValueRequest dimensionValues(String id) {
        return new DimensionValueRequest(contextPath.addSegment("dimensionValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DimensionValueCollectionRequest dimensionValues() {
        return new DimensionValueCollectionRequest(
                        contextPath.addSegment("dimensionValues"), Optional.empty());
    }

}
