package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Device;
import odata.msgraph.client.beta.entity.collection.request.CommandCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsageRightCollectionRequest;

@JsonIgnoreType
public class DeviceRequest extends EntityRequest<Device> {

    public DeviceRequest(ContextPath contextPath, Optional<Object> value) {
        super(Device.class, contextPath, value, false);
    }

    public UsageRightRequest usageRights(String id) {
        return new UsageRightRequest(contextPath.addSegment("usageRights").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UsageRightCollectionRequest usageRights() {
        return new UsageRightCollectionRequest(
                        contextPath.addSegment("usageRights"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

    public DirectoryObjectRequest registeredOwners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredOwners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest registeredOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredOwners"), Optional.empty());
    }

    public DirectoryObjectRequest registeredUsers(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredUsers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest registeredUsers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredUsers"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public CommandRequest commands(String id) {
        return new CommandRequest(contextPath.addSegment("commands").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CommandCollectionRequest commands() {
        return new CommandCollectionRequest(
                        contextPath.addSegment("commands"), Optional.empty());
    }

}
