package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementSettingComparison;
import odata.msgraph.client.beta.entity.DeviceManagementIntent;
import odata.msgraph.client.beta.entity.DeviceManagementSettingInstance;
import odata.msgraph.client.beta.entity.DeviceManagementTemplate;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateSettingCategoryCollectionRequest;

@JsonIgnoreType
public class DeviceManagementTemplateRequest extends EntityRequest<DeviceManagementTemplate> {

    public DeviceManagementTemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementTemplate.class, contextPath, value, false);
    }

    public DeviceManagementTemplateSettingCategoryRequest categories(String id) {
        return new DeviceManagementTemplateSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTemplateSettingCategoryCollectionRequest categories() {
        return new DeviceManagementTemplateSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceManagementTemplateRequest migratableTo(String id) {
        return new DeviceManagementTemplateRequest(contextPath.addSegment("migratableTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTemplateCollectionRequest migratableTo() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("migratableTo"), Optional.empty());
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"), Optional.empty());
    }

    @Action(name = "createInstance")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent> createInstance(String displayName, String description, List<DeviceManagementSettingInstance> settingsDelta, List<String> roleScopeTagIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .put("settingsDelta", "Collection(microsoft.graph.deviceManagementSettingInstance)", settingsDelta)
            .put("roleScopeTagIds", "Collection(Edm.String)", Checks.checkIsAscii(roleScopeTagIds))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createInstance"), DeviceManagementIntent.class, _parameters);
    }

    @Function(name = "compare")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementSettingComparison> compare(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.compare"), DeviceManagementSettingComparison.class, _parameters);
    }

}
