package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementScriptUserState;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptDeviceStateCollectionRequest;

@JsonIgnoreType
public class DeviceManagementScriptUserStateRequest extends EntityRequest<DeviceManagementScriptUserState> {

    public DeviceManagementScriptUserStateRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementScriptUserState.class, contextPath, value, false);
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

}
