package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementResourceAccessProfileAssignment;
import odata.msgraph.client.beta.entity.DeviceManagementResourceAccessProfileBase;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementResourceAccessProfileAssignmentCollectionRequest;

@JsonIgnoreType
public class DeviceManagementResourceAccessProfileBaseRequest extends EntityRequest<DeviceManagementResourceAccessProfileBase> {

    public DeviceManagementResourceAccessProfileBaseRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementResourceAccessProfileBase.class, contextPath, value, false);
    }

    public DeviceManagementResourceAccessProfileAssignmentRequest assignments(String id) {
        return new DeviceManagementResourceAccessProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementResourceAccessProfileAssignmentCollectionRequest assignments() {
        return new DeviceManagementResourceAccessProfileAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementResourceAccessProfileAssignment> assign(List<DeviceManagementResourceAccessProfileAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceManagementResourceAccessProfileAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceManagementResourceAccessProfileAssignment.class, _parameters);
    }

}
