package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.UnsupportedOperationException;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignmentFilterEvaluateRequest;
import odata.msgraph.client.beta.complex.AssignmentFilterStatusDetails;
import odata.msgraph.client.beta.complex.ComanagedDevicesSummary;
import odata.msgraph.client.beta.complex.ComanagementEligibleDevicesSummary;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignedRoleDetails;
import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.complex.SuggestedEnrollmentLimit;
import odata.msgraph.client.beta.complex.UserExperienceAnalyticsWorkFromAnywhereDevicesSummary;
import odata.msgraph.client.beta.entity.DeviceManagement;
import odata.msgraph.client.beta.entity.RoleScopeTag;
import odata.msgraph.client.beta.entity.collection.request.AndroidDeviceOwnerEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidManagedStoreAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppleUserInitiatedEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CartToClassAssociationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CertificateConnectorDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ChromeOSOnboardingSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudPCConnectivityIssueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComanagementEligibleDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComplianceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConfigManagerCollectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DataSharingConsentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DepOnboardingSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementAssignmentFilterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationConflictSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCustomAttributeShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationPolicyTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDerivedCredentialSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDomainJoinConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeOnPremisesPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementResourceAccessProfileBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementReusablePolicySettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyMigrationReportCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyObjectFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyUploadedDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IntuneBrandingProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosUpdateDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MacOSSoftwareUpdateAccountSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAllDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceEncryptionStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelHealthThresholdCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelServerLogCollectionResponseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftTunnelSiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileThreatDefenseConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NdesConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationMessageTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OemWarrantyInformationOnboardingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteActionAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteAssistancePartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedAppsViolationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TelecomExpenseManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBaselineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceScoresCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsImpactingProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsMetricHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsModelScoresCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsRemoteConnectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsResourcePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsScoreHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserPFXCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsDriverUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionAppLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionNetworkLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsMalwareInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsQualityUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsUpdateCatalogItemCollectionRequest;

@JsonIgnoreType
public class DeviceManagementRequest extends EntityRequest<DeviceManagement> {

    public DeviceManagementRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagement.class, contextPath, value, false);
    }

    public AndroidDeviceOwnerEnrollmentProfileRequest androidDeviceOwnerEnrollmentProfiles(String id) {
        return new AndroidDeviceOwnerEnrollmentProfileRequest(contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AndroidDeviceOwnerEnrollmentProfileCollectionRequest androidDeviceOwnerEnrollmentProfiles() {
        return new AndroidDeviceOwnerEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles"), Optional.empty());
    }

    public VirtualEndpointRequest virtualEndpoint() {
        return new VirtualEndpointRequest(contextPath.addSegment("virtualEndpoint"), Optional.empty());
    }

    public AndroidForWorkAppConfigurationSchemaRequest androidForWorkAppConfigurationSchemas(String id) {
        return new AndroidForWorkAppConfigurationSchemaRequest(contextPath.addSegment("androidForWorkAppConfigurationSchemas").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AndroidForWorkAppConfigurationSchemaCollectionRequest androidForWorkAppConfigurationSchemas() {
        return new AndroidForWorkAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidForWorkAppConfigurationSchemas"), Optional.empty());
    }

    public AndroidForWorkEnrollmentProfileRequest androidForWorkEnrollmentProfiles(String id) {
        return new AndroidForWorkEnrollmentProfileRequest(contextPath.addSegment("androidForWorkEnrollmentProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AndroidForWorkEnrollmentProfileCollectionRequest androidForWorkEnrollmentProfiles() {
        return new AndroidForWorkEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidForWorkEnrollmentProfiles"), Optional.empty());
    }

    public AndroidForWorkSettingsRequest androidForWorkSettings() {
        return new AndroidForWorkSettingsRequest(contextPath.addSegment("androidForWorkSettings"), Optional.empty());
    }

    public AndroidManagedStoreAccountEnterpriseSettingsRequest androidManagedStoreAccountEnterpriseSettings() {
        return new AndroidManagedStoreAccountEnterpriseSettingsRequest(contextPath.addSegment("androidManagedStoreAccountEnterpriseSettings"), Optional.empty());
    }

    public AndroidManagedStoreAppConfigurationSchemaRequest androidManagedStoreAppConfigurationSchemas(String id) {
        return new AndroidManagedStoreAppConfigurationSchemaRequest(contextPath.addSegment("androidManagedStoreAppConfigurationSchemas").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AndroidManagedStoreAppConfigurationSchemaCollectionRequest androidManagedStoreAppConfigurationSchemas() {
        return new AndroidManagedStoreAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidManagedStoreAppConfigurationSchemas"), Optional.empty());
    }

    public AuditEventRequest auditEvents(String id) {
        return new AuditEventRequest(contextPath.addSegment("auditEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuditEventCollectionRequest auditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"), Optional.empty());
    }

    public DeviceAndAppManagementAssignmentFilterRequest assignmentFilters(String id) {
        return new DeviceAndAppManagementAssignmentFilterRequest(contextPath.addSegment("assignmentFilters").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceAndAppManagementAssignmentFilterCollectionRequest assignmentFilters() {
        return new DeviceAndAppManagementAssignmentFilterCollectionRequest(
                        contextPath.addSegment("assignmentFilters"), Optional.empty());
    }

    public ChromeOSOnboardingSettingsRequest chromeOSOnboardingSettings(String id) {
        return new ChromeOSOnboardingSettingsRequest(contextPath.addSegment("chromeOSOnboardingSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChromeOSOnboardingSettingsCollectionRequest chromeOSOnboardingSettings() {
        return new ChromeOSOnboardingSettingsCollectionRequest(
                        contextPath.addSegment("chromeOSOnboardingSettings"), Optional.empty());
    }

    public TermsAndConditionsRequest termsAndConditions(String id) {
        return new TermsAndConditionsRequest(contextPath.addSegment("termsAndConditions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsCollectionRequest termsAndConditions() {
        return new TermsAndConditionsCollectionRequest(
                        contextPath.addSegment("termsAndConditions"), Optional.empty());
    }

    public AdvancedThreatProtectionOnboardingStateSummaryRequest advancedThreatProtectionOnboardingStateSummary() {
        return new AdvancedThreatProtectionOnboardingStateSummaryRequest(contextPath.addSegment("advancedThreatProtectionOnboardingStateSummary"), Optional.empty());
    }

    public CartToClassAssociationRequest cartToClassAssociations(String id) {
        return new CartToClassAssociationRequest(contextPath.addSegment("cartToClassAssociations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CartToClassAssociationCollectionRequest cartToClassAssociations() {
        return new CartToClassAssociationCollectionRequest(
                        contextPath.addSegment("cartToClassAssociations"), Optional.empty());
    }

    public DeviceCompliancePolicyRequest deviceCompliancePolicies(String id) {
        return new DeviceCompliancePolicyRequest(contextPath.addSegment("deviceCompliancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicyCollectionRequest deviceCompliancePolicies() {
        return new DeviceCompliancePolicyCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicies"), Optional.empty());
    }

    public DeviceCompliancePolicyDeviceStateSummaryRequest deviceCompliancePolicyDeviceStateSummary() {
        return new DeviceCompliancePolicyDeviceStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicyDeviceStateSummary"), Optional.empty());
    }

    public DeviceCompliancePolicySettingStateSummaryRequest deviceCompliancePolicySettingStateSummaries(String id) {
        return new DeviceCompliancePolicySettingStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicySettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCompliancePolicySettingStateSummaryCollectionRequest deviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"), Optional.empty());
    }

    public DeviceConfigurationConflictSummaryRequest deviceConfigurationConflictSummary(String id) {
        return new DeviceConfigurationConflictSummaryRequest(contextPath.addSegment("deviceConfigurationConflictSummary").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationConflictSummaryCollectionRequest deviceConfigurationConflictSummary() {
        return new DeviceConfigurationConflictSummaryCollectionRequest(
                        contextPath.addSegment("deviceConfigurationConflictSummary"), Optional.empty());
    }

    public DeviceConfigurationDeviceStateSummaryRequest deviceConfigurationDeviceStateSummaries() {
        return new DeviceConfigurationDeviceStateSummaryRequest(contextPath.addSegment("deviceConfigurationDeviceStateSummaries"), Optional.empty());
    }

    public RestrictedAppsViolationRequest deviceConfigurationRestrictedAppsViolations(String id) {
        return new RestrictedAppsViolationRequest(contextPath.addSegment("deviceConfigurationRestrictedAppsViolations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RestrictedAppsViolationCollectionRequest deviceConfigurationRestrictedAppsViolations() {
        return new RestrictedAppsViolationCollectionRequest(
                        contextPath.addSegment("deviceConfigurationRestrictedAppsViolations"), Optional.empty());
    }

    public DeviceConfigurationRequest deviceConfigurations(String id) {
        return new DeviceConfigurationRequest(contextPath.addSegment("deviceConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationCollectionRequest deviceConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("deviceConfigurations"), Optional.empty());
    }

    public ManagedAllDeviceCertificateStateRequest deviceConfigurationsAllManagedDeviceCertificateStates(String id) {
        return new ManagedAllDeviceCertificateStateRequest(contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedAllDeviceCertificateStateCollectionRequest deviceConfigurationsAllManagedDeviceCertificateStates() {
        return new ManagedAllDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates"), Optional.empty());
    }

    public DeviceConfigurationUserStateSummaryRequest deviceConfigurationUserStateSummaries() {
        return new DeviceConfigurationUserStateSummaryRequest(contextPath.addSegment("deviceConfigurationUserStateSummaries"), Optional.empty());
    }

    public IosUpdateDeviceStatusRequest iosUpdateStatuses(String id) {
        return new IosUpdateDeviceStatusRequest(contextPath.addSegment("iosUpdateStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IosUpdateDeviceStatusCollectionRequest iosUpdateStatuses() {
        return new IosUpdateDeviceStatusCollectionRequest(
                        contextPath.addSegment("iosUpdateStatuses"), Optional.empty());
    }

    public MacOSSoftwareUpdateAccountSummaryRequest macOSSoftwareUpdateAccountSummaries(String id) {
        return new MacOSSoftwareUpdateAccountSummaryRequest(contextPath.addSegment("macOSSoftwareUpdateAccountSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MacOSSoftwareUpdateAccountSummaryCollectionRequest macOSSoftwareUpdateAccountSummaries() {
        return new MacOSSoftwareUpdateAccountSummaryCollectionRequest(
                        contextPath.addSegment("macOSSoftwareUpdateAccountSummaries"), Optional.empty());
    }

    public ManagedDeviceEncryptionStateRequest managedDeviceEncryptionStates(String id) {
        return new ManagedDeviceEncryptionStateRequest(contextPath.addSegment("managedDeviceEncryptionStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceEncryptionStateCollectionRequest managedDeviceEncryptionStates() {
        return new ManagedDeviceEncryptionStateCollectionRequest(
                        contextPath.addSegment("managedDeviceEncryptionStates"), Optional.empty());
    }

    public NdesConnectorRequest ndesConnectors(String id) {
        return new NdesConnectorRequest(contextPath.addSegment("ndesConnectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NdesConnectorCollectionRequest ndesConnectors() {
        return new NdesConnectorCollectionRequest(
                        contextPath.addSegment("ndesConnectors"), Optional.empty());
    }

    public SoftwareUpdateStatusSummaryRequest softwareUpdateStatusSummary() {
        return new SoftwareUpdateStatusSummaryRequest(contextPath.addSegment("softwareUpdateStatusSummary"), Optional.empty());
    }

    public DeviceManagementConfigurationCategoryRequest complianceCategories(String id) {
        return new DeviceManagementConfigurationCategoryRequest(contextPath.addSegment("complianceCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationCategoryCollectionRequest complianceCategories() {
        return new DeviceManagementConfigurationCategoryCollectionRequest(
                        contextPath.addSegment("complianceCategories"), Optional.empty());
    }

    public DeviceManagementCompliancePolicyRequest compliancePolicies(String id) {
        return new DeviceManagementCompliancePolicyRequest(contextPath.addSegment("compliancePolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementCompliancePolicyCollectionRequest compliancePolicies() {
        return new DeviceManagementCompliancePolicyCollectionRequest(
                        contextPath.addSegment("compliancePolicies"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionRequest complianceSettings(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("complianceSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest complianceSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("complianceSettings"), Optional.empty());
    }

    public DeviceManagementConfigurationCategoryRequest configurationCategories(String id) {
        return new DeviceManagementConfigurationCategoryRequest(contextPath.addSegment("configurationCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationCategoryCollectionRequest configurationCategories() {
        return new DeviceManagementConfigurationCategoryCollectionRequest(
                        contextPath.addSegment("configurationCategories"), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyRequest configurationPolicies(String id) {
        return new DeviceManagementConfigurationPolicyRequest(contextPath.addSegment("configurationPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyCollectionRequest configurationPolicies() {
        return new DeviceManagementConfigurationPolicyCollectionRequest(
                        contextPath.addSegment("configurationPolicies"), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyTemplateRequest configurationPolicyTemplates(String id) {
        return new DeviceManagementConfigurationPolicyTemplateRequest(contextPath.addSegment("configurationPolicyTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationPolicyTemplateCollectionRequest configurationPolicyTemplates() {
        return new DeviceManagementConfigurationPolicyTemplateCollectionRequest(
                        contextPath.addSegment("configurationPolicyTemplates"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionRequest configurationSettings(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("configurationSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest configurationSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("configurationSettings"), Optional.empty());
    }

    public DeviceManagementReusablePolicySettingRequest reusablePolicySettings(String id) {
        return new DeviceManagementReusablePolicySettingRequest(contextPath.addSegment("reusablePolicySettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementReusablePolicySettingCollectionRequest reusablePolicySettings() {
        return new DeviceManagementReusablePolicySettingCollectionRequest(
                        contextPath.addSegment("reusablePolicySettings"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionRequest reusableSettings(String id) {
        return new DeviceManagementConfigurationSettingDefinitionRequest(contextPath.addSegment("reusableSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingDefinitionCollectionRequest reusableSettings() {
        return new DeviceManagementConfigurationSettingDefinitionCollectionRequest(
                        contextPath.addSegment("reusableSettings"), Optional.empty());
    }

    public DeviceManagementConfigurationSettingTemplateRequest templateSettings(String id) {
        return new DeviceManagementConfigurationSettingTemplateRequest(contextPath.addSegment("templateSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingTemplateCollectionRequest templateSettings() {
        return new DeviceManagementConfigurationSettingTemplateCollectionRequest(
                        contextPath.addSegment("templateSettings"), Optional.empty());
    }

    public ComplianceManagementPartnerRequest complianceManagementPartners(String id) {
        return new ComplianceManagementPartnerRequest(contextPath.addSegment("complianceManagementPartners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ComplianceManagementPartnerCollectionRequest complianceManagementPartners() {
        return new ComplianceManagementPartnerCollectionRequest(
                        contextPath.addSegment("complianceManagementPartners"), Optional.empty());
    }

    public OnPremisesConditionalAccessSettingsRequest conditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"), Optional.empty());
    }

    public DeviceCategoryRequest deviceCategories(String id) {
        return new DeviceCategoryRequest(contextPath.addSegment("deviceCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCategoryCollectionRequest deviceCategories() {
        return new DeviceCategoryCollectionRequest(
                        contextPath.addSegment("deviceCategories"), Optional.empty());
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"), Optional.empty());
    }

    public DeviceManagementPartnerRequest deviceManagementPartners(String id) {
        return new DeviceManagementPartnerRequest(contextPath.addSegment("deviceManagementPartners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementPartnerCollectionRequest deviceManagementPartners() {
        return new DeviceManagementPartnerCollectionRequest(
                        contextPath.addSegment("deviceManagementPartners"), Optional.empty());
    }

    public DeviceManagementExchangeConnectorRequest exchangeConnectors(String id) {
        return new DeviceManagementExchangeConnectorRequest(contextPath.addSegment("exchangeConnectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementExchangeConnectorCollectionRequest exchangeConnectors() {
        return new DeviceManagementExchangeConnectorCollectionRequest(
                        contextPath.addSegment("exchangeConnectors"), Optional.empty());
    }

    public DeviceManagementExchangeOnPremisesPolicyRequest exchangeOnPremisesPolicies(String id) {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementExchangeOnPremisesPolicyCollectionRequest exchangeOnPremisesPolicies() {
        return new DeviceManagementExchangeOnPremisesPolicyCollectionRequest(
                        contextPath.addSegment("exchangeOnPremisesPolicies"), Optional.empty());
    }

    public DeviceManagementExchangeOnPremisesPolicyRequest exchangeOnPremisesPolicy() {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicy"), Optional.empty());
    }

    public MobileThreatDefenseConnectorRequest mobileThreatDefenseConnectors(String id) {
        return new MobileThreatDefenseConnectorRequest(contextPath.addSegment("mobileThreatDefenseConnectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileThreatDefenseConnectorCollectionRequest mobileThreatDefenseConnectors() {
        return new MobileThreatDefenseConnectorCollectionRequest(
                        contextPath.addSegment("mobileThreatDefenseConnectors"), Optional.empty());
    }

    public DeviceManagementSettingCategoryRequest categories(String id) {
        return new DeviceManagementSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingCategoryCollectionRequest categories() {
        return new DeviceManagementSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceManagementIntentRequest intents(String id) {
        return new DeviceManagementIntentRequest(contextPath.addSegment("intents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentCollectionRequest intents() {
        return new DeviceManagementIntentCollectionRequest(
                        contextPath.addSegment("intents"), Optional.empty());
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"), Optional.empty());
    }

    public DeviceManagementTemplateRequest templates(String id) {
        return new DeviceManagementTemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTemplateCollectionRequest templates() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("templates"), Optional.empty());
    }

    public ApplePushNotificationCertificateRequest applePushNotificationCertificate() {
        return new ApplePushNotificationCertificateRequest(contextPath.addSegment("applePushNotificationCertificate"), Optional.empty());
    }

    public CloudPCConnectivityIssueRequest cloudPCConnectivityIssues(String id) {
        return new CloudPCConnectivityIssueRequest(contextPath.addSegment("cloudPCConnectivityIssues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CloudPCConnectivityIssueCollectionRequest cloudPCConnectivityIssues() {
        return new CloudPCConnectivityIssueCollectionRequest(
                        contextPath.addSegment("cloudPCConnectivityIssues"), Optional.empty());
    }

    public ManagedDeviceRequest comanagedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("comanagedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest comanagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("comanagedDevices"), Optional.empty());
    }

    public ComanagementEligibleDeviceRequest comanagementEligibleDevices(String id) {
        return new ComanagementEligibleDeviceRequest(contextPath.addSegment("comanagementEligibleDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ComanagementEligibleDeviceCollectionRequest comanagementEligibleDevices() {
        return new ComanagementEligibleDeviceCollectionRequest(
                        contextPath.addSegment("comanagementEligibleDevices"), Optional.empty());
    }

    public DataSharingConsentRequest dataSharingConsents(String id) {
        return new DataSharingConsentRequest(contextPath.addSegment("dataSharingConsents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DataSharingConsentCollectionRequest dataSharingConsents() {
        return new DataSharingConsentCollectionRequest(
                        contextPath.addSegment("dataSharingConsents"), Optional.empty());
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"), Optional.empty());
    }

    public DeviceComplianceScriptRequest deviceComplianceScripts(String id) {
        return new DeviceComplianceScriptRequest(contextPath.addSegment("deviceComplianceScripts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceScriptCollectionRequest deviceComplianceScripts() {
        return new DeviceComplianceScriptCollectionRequest(
                        contextPath.addSegment("deviceComplianceScripts"), Optional.empty());
    }

    public DeviceCustomAttributeShellScriptRequest deviceCustomAttributeShellScripts(String id) {
        return new DeviceCustomAttributeShellScriptRequest(contextPath.addSegment("deviceCustomAttributeShellScripts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceCustomAttributeShellScriptCollectionRequest deviceCustomAttributeShellScripts() {
        return new DeviceCustomAttributeShellScriptCollectionRequest(
                        contextPath.addSegment("deviceCustomAttributeShellScripts"), Optional.empty());
    }

    public DeviceHealthScriptRequest deviceHealthScripts(String id) {
        return new DeviceHealthScriptRequest(contextPath.addSegment("deviceHealthScripts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceHealthScriptCollectionRequest deviceHealthScripts() {
        return new DeviceHealthScriptCollectionRequest(
                        contextPath.addSegment("deviceHealthScripts"), Optional.empty());
    }

    public DeviceManagementScriptRequest deviceManagementScripts(String id) {
        return new DeviceManagementScriptRequest(contextPath.addSegment("deviceManagementScripts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementScriptCollectionRequest deviceManagementScripts() {
        return new DeviceManagementScriptCollectionRequest(
                        contextPath.addSegment("deviceManagementScripts"), Optional.empty());
    }

    public DeviceShellScriptRequest deviceShellScripts(String id) {
        return new DeviceShellScriptRequest(contextPath.addSegment("deviceShellScripts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceShellScriptCollectionRequest deviceShellScripts() {
        return new DeviceShellScriptCollectionRequest(
                        contextPath.addSegment("deviceShellScripts"), Optional.empty());
    }

    public ManagedDeviceOverviewRequest managedDeviceOverview() {
        return new ManagedDeviceOverviewRequest(contextPath.addSegment("managedDeviceOverview"), Optional.empty());
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.empty());
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"), Optional.empty());
    }

    public OemWarrantyInformationOnboardingRequest oemWarrantyInformationOnboarding(String id) {
        return new OemWarrantyInformationOnboardingRequest(contextPath.addSegment("oemWarrantyInformationOnboarding").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OemWarrantyInformationOnboardingCollectionRequest oemWarrantyInformationOnboarding() {
        return new OemWarrantyInformationOnboardingCollectionRequest(
                        contextPath.addSegment("oemWarrantyInformationOnboarding"), Optional.empty());
    }

    public RemoteActionAuditRequest remoteActionAudits(String id) {
        return new RemoteActionAuditRequest(contextPath.addSegment("remoteActionAudits").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RemoteActionAuditCollectionRequest remoteActionAudits() {
        return new RemoteActionAuditCollectionRequest(
                        contextPath.addSegment("remoteActionAudits"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthApplicationPerformanceRequest userExperienceAnalyticsAppHealthApplicationPerformance(String id) {
        return new UserExperienceAnalyticsAppHealthApplicationPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest userExperienceAnalyticsAppHealthApplicationPerformance() {
        return new UserExperienceAnalyticsAppHealthApplicationPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion(String id) {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersion"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails(String id) {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDetailsCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDetails"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId(String id) {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByAppVersionDeviceIdCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByAppVersionDeviceId"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion(String id) {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion() {
        return new UserExperienceAnalyticsAppHealthAppPerformanceByOSVersionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthApplicationPerformanceByOSVersion"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest userExperienceAnalyticsAppHealthDeviceModelPerformance(String id) {
        return new UserExperienceAnalyticsAppHealthDeviceModelPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthDeviceModelPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest userExperienceAnalyticsAppHealthDeviceModelPerformance() {
        return new UserExperienceAnalyticsAppHealthDeviceModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDeviceModelPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDevicePerformanceRequest userExperienceAnalyticsAppHealthDevicePerformance(String id) {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest userExperienceAnalyticsAppHealthDevicePerformance() {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDevicePerformanceDetailsRequest userExperienceAnalyticsAppHealthDevicePerformanceDetails(String id) {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceDetailsRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformanceDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest userExperienceAnalyticsAppHealthDevicePerformanceDetails() {
        return new UserExperienceAnalyticsAppHealthDevicePerformanceDetailsCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthDevicePerformanceDetails"), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest userExperienceAnalyticsAppHealthOSVersionPerformance(String id) {
        return new UserExperienceAnalyticsAppHealthOSVersionPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthOSVersionPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest userExperienceAnalyticsAppHealthOSVersionPerformance() {
        return new UserExperienceAnalyticsAppHealthOSVersionPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsAppHealthOSVersionPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest userExperienceAnalyticsAppHealthOverview() {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("userExperienceAnalyticsAppHealthOverview"), Optional.empty());
    }

    public UserExperienceAnalyticsBaselineRequest userExperienceAnalyticsBaselines(String id) {
        return new UserExperienceAnalyticsBaselineRequest(contextPath.addSegment("userExperienceAnalyticsBaselines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBaselineCollectionRequest userExperienceAnalyticsBaselines() {
        return new UserExperienceAnalyticsBaselineCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBaselines"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthAppImpactRequest userExperienceAnalyticsBatteryHealthAppImpact(String id) {
        return new UserExperienceAnalyticsBatteryHealthAppImpactRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthAppImpact").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest userExperienceAnalyticsBatteryHealthAppImpact() {
        return new UserExperienceAnalyticsBatteryHealthAppImpactCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthAppImpact"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthCapacityDetailsRequest userExperienceAnalyticsBatteryHealthCapacityDetails() {
        return new UserExperienceAnalyticsBatteryHealthCapacityDetailsRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthCapacityDetails"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDeviceAppImpactRequest userExperienceAnalyticsBatteryHealthDeviceAppImpact(String id) {
        return new UserExperienceAnalyticsBatteryHealthDeviceAppImpactRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceAppImpact").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest userExperienceAnalyticsBatteryHealthDeviceAppImpact() {
        return new UserExperienceAnalyticsBatteryHealthDeviceAppImpactCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceAppImpact"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDevicePerformanceRequest userExperienceAnalyticsBatteryHealthDevicePerformance(String id) {
        return new UserExperienceAnalyticsBatteryHealthDevicePerformanceRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthDevicePerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest userExperienceAnalyticsBatteryHealthDevicePerformance() {
        return new UserExperienceAnalyticsBatteryHealthDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDevicePerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryRequest userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory(String id) {
        return new UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory() {
        return new UserExperienceAnalyticsBatteryHealthDeviceRuntimeHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthDeviceRuntimeHistory"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthModelPerformanceRequest userExperienceAnalyticsBatteryHealthModelPerformance(String id) {
        return new UserExperienceAnalyticsBatteryHealthModelPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthModelPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest userExperienceAnalyticsBatteryHealthModelPerformance() {
        return new UserExperienceAnalyticsBatteryHealthModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthModelPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthOsPerformanceRequest userExperienceAnalyticsBatteryHealthOsPerformance(String id) {
        return new UserExperienceAnalyticsBatteryHealthOsPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthOsPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest userExperienceAnalyticsBatteryHealthOsPerformance() {
        return new UserExperienceAnalyticsBatteryHealthOsPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBatteryHealthOsPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsBatteryHealthRuntimeDetailsRequest userExperienceAnalyticsBatteryHealthRuntimeDetails() {
        return new UserExperienceAnalyticsBatteryHealthRuntimeDetailsRequest(contextPath.addSegment("userExperienceAnalyticsBatteryHealthRuntimeDetails"), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryRequest userExperienceAnalyticsCategories(String id) {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("userExperienceAnalyticsCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsCategoryCollectionRequest userExperienceAnalyticsCategories() {
        return new UserExperienceAnalyticsCategoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsCategories"), Optional.empty());
    }

    public UserExperienceAnalyticsMetricHistoryRequest userExperienceAnalyticsDeviceMetricHistory(String id) {
        return new UserExperienceAnalyticsMetricHistoryRequest(contextPath.addSegment("userExperienceAnalyticsDeviceMetricHistory").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricHistoryCollectionRequest userExperienceAnalyticsDeviceMetricHistory() {
        return new UserExperienceAnalyticsMetricHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceMetricHistory"), Optional.empty());
    }

    public UserExperienceAnalyticsDevicePerformanceRequest userExperienceAnalyticsDevicePerformance(String id) {
        return new UserExperienceAnalyticsDevicePerformanceRequest(contextPath.addSegment("userExperienceAnalyticsDevicePerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDevicePerformanceCollectionRequest userExperienceAnalyticsDevicePerformance() {
        return new UserExperienceAnalyticsDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicePerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceScoresRequest userExperienceAnalyticsDeviceScores(String id) {
        return new UserExperienceAnalyticsDeviceScoresRequest(contextPath.addSegment("userExperienceAnalyticsDeviceScores").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceScoresCollectionRequest userExperienceAnalyticsDeviceScores() {
        return new UserExperienceAnalyticsDeviceScoresCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceScores"), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupHistoryRequest userExperienceAnalyticsDeviceStartupHistory(String id) {
        return new UserExperienceAnalyticsDeviceStartupHistoryRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest userExperienceAnalyticsDeviceStartupHistory() {
        return new UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory"), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupProcessRequest userExperienceAnalyticsDeviceStartupProcesses(String id) {
        return new UserExperienceAnalyticsDeviceStartupProcessRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupProcessCollectionRequest userExperienceAnalyticsDeviceStartupProcesses() {
        return new UserExperienceAnalyticsDeviceStartupProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses"), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest userExperienceAnalyticsDeviceStartupProcessPerformance(String id) {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest userExperienceAnalyticsDeviceStartupProcessPerformance() {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceWithoutCloudIdentityRequest userExperienceAnalyticsDevicesWithoutCloudIdentity(String id) {
        return new UserExperienceAnalyticsDeviceWithoutCloudIdentityRequest(contextPath.addSegment("userExperienceAnalyticsDevicesWithoutCloudIdentity").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest userExperienceAnalyticsDevicesWithoutCloudIdentity() {
        return new UserExperienceAnalyticsDeviceWithoutCloudIdentityCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicesWithoutCloudIdentity"), Optional.empty());
    }

    public UserExperienceAnalyticsImpactingProcessRequest userExperienceAnalyticsImpactingProcess(String id) {
        return new UserExperienceAnalyticsImpactingProcessRequest(contextPath.addSegment("userExperienceAnalyticsImpactingProcess").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsImpactingProcessCollectionRequest userExperienceAnalyticsImpactingProcess() {
        return new UserExperienceAnalyticsImpactingProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsImpactingProcess"), Optional.empty());
    }

    public UserExperienceAnalyticsMetricHistoryRequest userExperienceAnalyticsMetricHistory(String id) {
        return new UserExperienceAnalyticsMetricHistoryRequest(contextPath.addSegment("userExperienceAnalyticsMetricHistory").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricHistoryCollectionRequest userExperienceAnalyticsMetricHistory() {
        return new UserExperienceAnalyticsMetricHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsMetricHistory"), Optional.empty());
    }

    public UserExperienceAnalyticsModelScoresRequest userExperienceAnalyticsModelScores(String id) {
        return new UserExperienceAnalyticsModelScoresRequest(contextPath.addSegment("userExperienceAnalyticsModelScores").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsModelScoresCollectionRequest userExperienceAnalyticsModelScores() {
        return new UserExperienceAnalyticsModelScoresCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsModelScores"), Optional.empty());
    }

    public UserExperienceAnalyticsNotAutopilotReadyDeviceRequest userExperienceAnalyticsNotAutopilotReadyDevice(String id) {
        return new UserExperienceAnalyticsNotAutopilotReadyDeviceRequest(contextPath.addSegment("userExperienceAnalyticsNotAutopilotReadyDevice").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest userExperienceAnalyticsNotAutopilotReadyDevice() {
        return new UserExperienceAnalyticsNotAutopilotReadyDeviceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsNotAutopilotReadyDevice"), Optional.empty());
    }

    public UserExperienceAnalyticsOverviewRequest userExperienceAnalyticsOverview() {
        return new UserExperienceAnalyticsOverviewRequest(contextPath.addSegment("userExperienceAnalyticsOverview"), Optional.empty());
    }

    public UserExperienceAnalyticsRegressionSummaryRequest userExperienceAnalyticsRegressionSummary() {
        return new UserExperienceAnalyticsRegressionSummaryRequest(contextPath.addSegment("userExperienceAnalyticsRegressionSummary"), Optional.empty());
    }

    public UserExperienceAnalyticsRemoteConnectionRequest userExperienceAnalyticsRemoteConnection(String id) {
        return new UserExperienceAnalyticsRemoteConnectionRequest(contextPath.addSegment("userExperienceAnalyticsRemoteConnection").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsRemoteConnectionCollectionRequest userExperienceAnalyticsRemoteConnection() {
        return new UserExperienceAnalyticsRemoteConnectionCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsRemoteConnection"), Optional.empty());
    }

    public UserExperienceAnalyticsResourcePerformanceRequest userExperienceAnalyticsResourcePerformance(String id) {
        return new UserExperienceAnalyticsResourcePerformanceRequest(contextPath.addSegment("userExperienceAnalyticsResourcePerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsResourcePerformanceCollectionRequest userExperienceAnalyticsResourcePerformance() {
        return new UserExperienceAnalyticsResourcePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsResourcePerformance"), Optional.empty());
    }

    public UserExperienceAnalyticsScoreHistoryRequest userExperienceAnalyticsScoreHistory(String id) {
        return new UserExperienceAnalyticsScoreHistoryRequest(contextPath.addSegment("userExperienceAnalyticsScoreHistory").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsScoreHistoryCollectionRequest userExperienceAnalyticsScoreHistory() {
        return new UserExperienceAnalyticsScoreHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsScoreHistory"), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetricRequest userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric() {
        return new UserExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetricRequest(contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereHardwareReadinessMetric"), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereMetricRequest userExperienceAnalyticsWorkFromAnywhereMetrics(String id) {
        return new UserExperienceAnalyticsWorkFromAnywhereMetricRequest(contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereMetrics").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest userExperienceAnalyticsWorkFromAnywhereMetrics() {
        return new UserExperienceAnalyticsWorkFromAnywhereMetricCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereMetrics"), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest userExperienceAnalyticsWorkFromAnywhereModelPerformance(String id) {
        return new UserExperienceAnalyticsWorkFromAnywhereModelPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereModelPerformance").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest userExperienceAnalyticsWorkFromAnywhereModelPerformance() {
        return new UserExperienceAnalyticsWorkFromAnywhereModelPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsWorkFromAnywhereModelPerformance"), Optional.empty());
    }

    public WindowsMalwareInformationRequest windowsMalwareInformation(String id) {
        return new WindowsMalwareInformationRequest(contextPath.addSegment("windowsMalwareInformation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsMalwareInformationCollectionRequest windowsMalwareInformation() {
        return new WindowsMalwareInformationCollectionRequest(
                        contextPath.addSegment("windowsMalwareInformation"), Optional.empty());
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentials(String id) {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentials").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementDerivedCredentialSettingsCollectionRequest derivedCredentials() {
        return new DeviceManagementDerivedCredentialSettingsCollectionRequest(
                        contextPath.addSegment("derivedCredentials"), Optional.empty());
    }

    public DeviceManagementResourceAccessProfileBaseRequest resourceAccessProfiles(String id) {
        return new DeviceManagementResourceAccessProfileBaseRequest(contextPath.addSegment("resourceAccessProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementResourceAccessProfileBaseCollectionRequest resourceAccessProfiles() {
        return new DeviceManagementResourceAccessProfileBaseCollectionRequest(
                        contextPath.addSegment("resourceAccessProfiles"), Optional.empty());
    }

    public AppleUserInitiatedEnrollmentProfileRequest appleUserInitiatedEnrollmentProfiles(String id) {
        return new AppleUserInitiatedEnrollmentProfileRequest(contextPath.addSegment("appleUserInitiatedEnrollmentProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppleUserInitiatedEnrollmentProfileCollectionRequest appleUserInitiatedEnrollmentProfiles() {
        return new AppleUserInitiatedEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("appleUserInitiatedEnrollmentProfiles"), Optional.empty());
    }

    public DepOnboardingSettingRequest depOnboardingSettings(String id) {
        return new DepOnboardingSettingRequest(contextPath.addSegment("depOnboardingSettings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DepOnboardingSettingCollectionRequest depOnboardingSettings() {
        return new DepOnboardingSettingCollectionRequest(
                        contextPath.addSegment("depOnboardingSettings"), Optional.empty());
    }

    public ImportedDeviceIdentityRequest importedDeviceIdentities(String id) {
        return new ImportedDeviceIdentityRequest(contextPath.addSegment("importedDeviceIdentities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ImportedDeviceIdentityCollectionRequest importedDeviceIdentities() {
        return new ImportedDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedDeviceIdentities"), Optional.empty());
    }

    public ImportedWindowsAutopilotDeviceIdentityRequest importedWindowsAutopilotDeviceIdentities(String id) {
        return new ImportedWindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("importedWindowsAutopilotDeviceIdentities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest importedWindowsAutopilotDeviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedWindowsAutopilotDeviceIdentities"), Optional.empty());
    }

    public WindowsAutopilotDeploymentProfileRequest windowsAutopilotDeploymentProfiles(String id) {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("windowsAutopilotDeploymentProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsAutopilotDeploymentProfileCollectionRequest windowsAutopilotDeploymentProfiles() {
        return new WindowsAutopilotDeploymentProfileCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeploymentProfiles"), Optional.empty());
    }

    public WindowsAutopilotDeviceIdentityRequest windowsAutopilotDeviceIdentities(String id) {
        return new WindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("windowsAutopilotDeviceIdentities").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsAutopilotDeviceIdentityCollectionRequest windowsAutopilotDeviceIdentities() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeviceIdentities"), Optional.empty());
    }

    public WindowsAutopilotSettingsRequest windowsAutopilotSettings() {
        return new WindowsAutopilotSettingsRequest(contextPath.addSegment("windowsAutopilotSettings"), Optional.empty());
    }

    public ManagementConditionRequest managementConditions(String id) {
        return new ManagementConditionRequest(contextPath.addSegment("managementConditions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementConditionCollectionRequest managementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"), Optional.empty());
    }

    public ManagementConditionStatementRequest managementConditionStatements(String id) {
        return new ManagementConditionStatementRequest(contextPath.addSegment("managementConditionStatements").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ManagementConditionStatementCollectionRequest managementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"), Optional.empty());
    }

    public GroupPolicyMigrationReportRequest groupPolicyMigrationReports(String id) {
        return new GroupPolicyMigrationReportRequest(contextPath.addSegment("groupPolicyMigrationReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyMigrationReportCollectionRequest groupPolicyMigrationReports() {
        return new GroupPolicyMigrationReportCollectionRequest(
                        contextPath.addSegment("groupPolicyMigrationReports"), Optional.empty());
    }

    public GroupPolicyObjectFileRequest groupPolicyObjectFiles(String id) {
        return new GroupPolicyObjectFileRequest(contextPath.addSegment("groupPolicyObjectFiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyObjectFileCollectionRequest groupPolicyObjectFiles() {
        return new GroupPolicyObjectFileCollectionRequest(
                        contextPath.addSegment("groupPolicyObjectFiles"), Optional.empty());
    }

    public GroupPolicyCategoryRequest groupPolicyCategories(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("groupPolicyCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyCategoryCollectionRequest groupPolicyCategories() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("groupPolicyCategories"), Optional.empty());
    }

    public GroupPolicyConfigurationRequest groupPolicyConfigurations(String id) {
        return new GroupPolicyConfigurationRequest(contextPath.addSegment("groupPolicyConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyConfigurationCollectionRequest groupPolicyConfigurations() {
        return new GroupPolicyConfigurationCollectionRequest(
                        contextPath.addSegment("groupPolicyConfigurations"), Optional.empty());
    }

    public GroupPolicyDefinitionFileRequest groupPolicyDefinitionFiles(String id) {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("groupPolicyDefinitionFiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionFileCollectionRequest groupPolicyDefinitionFiles() {
        return new GroupPolicyDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitionFiles"), Optional.empty());
    }

    public GroupPolicyDefinitionRequest groupPolicyDefinitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("groupPolicyDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyDefinitionCollectionRequest groupPolicyDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitions"), Optional.empty());
    }

    public GroupPolicyUploadedDefinitionFileRequest groupPolicyUploadedDefinitionFiles(String id) {
        return new GroupPolicyUploadedDefinitionFileRequest(contextPath.addSegment("groupPolicyUploadedDefinitionFiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupPolicyUploadedDefinitionFileCollectionRequest groupPolicyUploadedDefinitionFiles() {
        return new GroupPolicyUploadedDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyUploadedDefinitionFiles"), Optional.empty());
    }

    public MicrosoftTunnelConfigurationRequest microsoftTunnelConfigurations(String id) {
        return new MicrosoftTunnelConfigurationRequest(contextPath.addSegment("microsoftTunnelConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelConfigurationCollectionRequest microsoftTunnelConfigurations() {
        return new MicrosoftTunnelConfigurationCollectionRequest(
                        contextPath.addSegment("microsoftTunnelConfigurations"), Optional.empty());
    }

    public MicrosoftTunnelHealthThresholdRequest microsoftTunnelHealthThresholds(String id) {
        return new MicrosoftTunnelHealthThresholdRequest(contextPath.addSegment("microsoftTunnelHealthThresholds").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelHealthThresholdCollectionRequest microsoftTunnelHealthThresholds() {
        return new MicrosoftTunnelHealthThresholdCollectionRequest(
                        contextPath.addSegment("microsoftTunnelHealthThresholds"), Optional.empty());
    }

    public MicrosoftTunnelServerLogCollectionResponseRequest microsoftTunnelServerLogCollectionResponses(String id) {
        return new MicrosoftTunnelServerLogCollectionResponseRequest(contextPath.addSegment("microsoftTunnelServerLogCollectionResponses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelServerLogCollectionResponseCollectionRequest microsoftTunnelServerLogCollectionResponses() {
        return new MicrosoftTunnelServerLogCollectionResponseCollectionRequest(
                        contextPath.addSegment("microsoftTunnelServerLogCollectionResponses"), Optional.empty());
    }

    public MicrosoftTunnelSiteRequest microsoftTunnelSites(String id) {
        return new MicrosoftTunnelSiteRequest(contextPath.addSegment("microsoftTunnelSites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MicrosoftTunnelSiteCollectionRequest microsoftTunnelSites() {
        return new MicrosoftTunnelSiteCollectionRequest(
                        contextPath.addSegment("microsoftTunnelSites"), Optional.empty());
    }

    public NotificationMessageTemplateRequest notificationMessageTemplates(String id) {
        return new NotificationMessageTemplateRequest(contextPath.addSegment("notificationMessageTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NotificationMessageTemplateCollectionRequest notificationMessageTemplates() {
        return new NotificationMessageTemplateCollectionRequest(
                        contextPath.addSegment("notificationMessageTemplates"), Optional.empty());
    }

    public DeviceManagementDomainJoinConnectorRequest domainJoinConnectors(String id) {
        return new DeviceManagementDomainJoinConnectorRequest(contextPath.addSegment("domainJoinConnectors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementDomainJoinConnectorCollectionRequest domainJoinConnectors() {
        return new DeviceManagementDomainJoinConnectorCollectionRequest(
                        contextPath.addSegment("domainJoinConnectors"), Optional.empty());
    }

    public ConfigManagerCollectionRequest configManagerCollections(String id) {
        return new ConfigManagerCollectionRequest(contextPath.addSegment("configManagerCollections").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConfigManagerCollectionCollectionRequest configManagerCollections() {
        return new ConfigManagerCollectionCollectionRequest(
                        contextPath.addSegment("configManagerCollections"), Optional.empty());
    }

    public ResourceOperationRequest resourceOperations(String id) {
        return new ResourceOperationRequest(contextPath.addSegment("resourceOperations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceOperationCollectionRequest resourceOperations() {
        return new ResourceOperationCollectionRequest(
                        contextPath.addSegment("resourceOperations"), Optional.empty());
    }

    public DeviceAndAppManagementRoleAssignmentRequest roleAssignments(String id) {
        return new DeviceAndAppManagementRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceAndAppManagementRoleAssignmentCollectionRequest roleAssignments() {
        return new DeviceAndAppManagementRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"), Optional.empty());
    }

    public RoleDefinitionRequest roleDefinitions(String id) {
        return new RoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleDefinitionCollectionRequest roleDefinitions() {
        return new RoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"), Optional.empty());
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"), Optional.empty());
    }

    public RemoteAssistancePartnerRequest remoteAssistancePartners(String id) {
        return new RemoteAssistancePartnerRequest(contextPath.addSegment("remoteAssistancePartners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RemoteAssistancePartnerCollectionRequest remoteAssistancePartners() {
        return new RemoteAssistancePartnerCollectionRequest(
                        contextPath.addSegment("remoteAssistancePartners"), Optional.empty());
    }

    public RemoteAssistanceSettingsRequest remoteAssistanceSettings() {
        return new RemoteAssistanceSettingsRequest(contextPath.addSegment("remoteAssistanceSettings"), Optional.empty());
    }

    public DeviceManagementReportsRequest reports() {
        return new DeviceManagementReportsRequest(contextPath.addSegment("reports"), Optional.empty());
    }

    public EmbeddedSIMActivationCodePoolRequest embeddedSIMActivationCodePools(String id) {
        return new EmbeddedSIMActivationCodePoolRequest(contextPath.addSegment("embeddedSIMActivationCodePools").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmbeddedSIMActivationCodePoolCollectionRequest embeddedSIMActivationCodePools() {
        return new EmbeddedSIMActivationCodePoolCollectionRequest(
                        contextPath.addSegment("embeddedSIMActivationCodePools"), Optional.empty());
    }

    public TelecomExpenseManagementPartnerRequest telecomExpenseManagementPartners(String id) {
        return new TelecomExpenseManagementPartnerRequest(contextPath.addSegment("telecomExpenseManagementPartners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TelecomExpenseManagementPartnerCollectionRequest telecomExpenseManagementPartners() {
        return new TelecomExpenseManagementPartnerCollectionRequest(
                        contextPath.addSegment("telecomExpenseManagementPartners"), Optional.empty());
    }

    public DeviceManagementAutopilotEventRequest autopilotEvents(String id) {
        return new DeviceManagementAutopilotEventRequest(contextPath.addSegment("autopilotEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementAutopilotEventCollectionRequest autopilotEvents() {
        return new DeviceManagementAutopilotEventCollectionRequest(
                        contextPath.addSegment("autopilotEvents"), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventRequest troubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("troubleshootingEvents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementTroubleshootingEventCollectionRequest troubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("troubleshootingEvents"), Optional.empty());
    }

    public WindowsDriverUpdateProfileRequest windowsDriverUpdateProfiles(String id) {
        return new WindowsDriverUpdateProfileRequest(contextPath.addSegment("windowsDriverUpdateProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDriverUpdateProfileCollectionRequest windowsDriverUpdateProfiles() {
        return new WindowsDriverUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsDriverUpdateProfiles"), Optional.empty());
    }

    public WindowsFeatureUpdateProfileRequest windowsFeatureUpdateProfiles(String id) {
        return new WindowsFeatureUpdateProfileRequest(contextPath.addSegment("windowsFeatureUpdateProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsFeatureUpdateProfileCollectionRequest windowsFeatureUpdateProfiles() {
        return new WindowsFeatureUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsFeatureUpdateProfiles"), Optional.empty());
    }

    public WindowsQualityUpdateProfileRequest windowsQualityUpdateProfiles(String id) {
        return new WindowsQualityUpdateProfileRequest(contextPath.addSegment("windowsQualityUpdateProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsQualityUpdateProfileCollectionRequest windowsQualityUpdateProfiles() {
        return new WindowsQualityUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsQualityUpdateProfiles"), Optional.empty());
    }

    public WindowsUpdateCatalogItemRequest windowsUpdateCatalogItems(String id) {
        return new WindowsUpdateCatalogItemRequest(contextPath.addSegment("windowsUpdateCatalogItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsUpdateCatalogItemCollectionRequest windowsUpdateCatalogItems() {
        return new WindowsUpdateCatalogItemCollectionRequest(
                        contextPath.addSegment("windowsUpdateCatalogItems"), Optional.empty());
    }

    public IntuneBrandingProfileRequest intuneBrandingProfiles(String id) {
        return new IntuneBrandingProfileRequest(contextPath.addSegment("intuneBrandingProfiles").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public IntuneBrandingProfileCollectionRequest intuneBrandingProfiles() {
        return new IntuneBrandingProfileCollectionRequest(
                        contextPath.addSegment("intuneBrandingProfiles"), Optional.empty());
    }

    public WindowsInformationProtectionAppLearningSummaryRequest windowsInformationProtectionAppLearningSummaries(String id) {
        return new WindowsInformationProtectionAppLearningSummaryRequest(contextPath.addSegment("windowsInformationProtectionAppLearningSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsInformationProtectionAppLearningSummaryCollectionRequest windowsInformationProtectionAppLearningSummaries() {
        return new WindowsInformationProtectionAppLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionAppLearningSummaries"), Optional.empty());
    }

    public WindowsInformationProtectionNetworkLearningSummaryRequest windowsInformationProtectionNetworkLearningSummaries(String id) {
        return new WindowsInformationProtectionNetworkLearningSummaryRequest(contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsInformationProtectionNetworkLearningSummaryCollectionRequest windowsInformationProtectionNetworkLearningSummaries() {
        return new WindowsInformationProtectionNetworkLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries"), Optional.empty());
    }

    public CertificateConnectorDetailsRequest certificateConnectorDetails(String id) {
        return new CertificateConnectorDetailsRequest(contextPath.addSegment("certificateConnectorDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CertificateConnectorDetailsCollectionRequest certificateConnectorDetails() {
        return new CertificateConnectorDetailsCollectionRequest(
                        contextPath.addSegment("certificateConnectorDetails"), Optional.empty());
    }

    public UserPFXCertificateRequest userPfxCertificates(String id) {
        return new UserPFXCertificateRequest(contextPath.addSegment("userPfxCertificates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserPFXCertificateCollectionRequest userPfxCertificates() {
        return new UserPFXCertificateCollectionRequest(
                        contextPath.addSegment("userPfxCertificates"), Optional.empty());
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody, List<String> groupsToNotify) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("groupsToNotify", "Collection(Edm.String)", Checks.checkIsAscii(groupsToNotify))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Action(name = "evaluateAssignmentFilter")
    @JsonIgnore
    public FunctionRequestReturningStream evaluateAssignmentFilter(AssignmentFilterEvaluateRequest data) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("data", "microsoft.graph.assignmentFilterEvaluateRequest", data)
            .build();
        throw new UnsupportedOperationException("Actions that return a stream are not supported yet. If you want this raise an issue at the project home");
    }

    @Action(name = "getAssignmentFiltersStatusDetails")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterStatusDetails> getAssignmentFiltersStatusDetails(String managedDeviceId, String payloadId, String userId, List<String> assignmentFilterIds, Integer top, Integer skip) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("managedDeviceId", "Edm.String", Checks.checkIsAscii(managedDeviceId))
            .put("payloadId", "Edm.String", Checks.checkIsAscii(payloadId))
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("assignmentFilterIds", "Collection(Edm.String)", Checks.checkIsAscii(assignmentFilterIds))
            .put("top", "Edm.Int32", top)
            .put("skip", "Edm.Int32", skip)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AssignmentFilterStatusDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignmentFiltersStatusDetails"), AssignmentFilterStatusDetails.class, _parameters);
    }

    @Action(name = "enableAndroidDeviceAdministratorEnrollment")
    @JsonIgnore
    public ActionRequestNoReturn enableAndroidDeviceAdministratorEnrollment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableAndroidDeviceAdministratorEnrollment"), _parameters);
    }

    @Action(name = "enableLegacyPcManagement")
    @JsonIgnore
    public ActionRequestNoReturn enableLegacyPcManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLegacyPcManagement"), _parameters);
    }

    @Action(name = "enableUnlicensedAdminstrators")
    @JsonIgnore
    public ActionRequestNoReturn enableUnlicensedAdminstrators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableUnlicensedAdminstrators"), _parameters);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RolePermission> getEffectivePermissions_Function(String scope) {
        Preconditions.checkNotNull(scope, "scope cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), RolePermission.class, _parameters);
    }

    @Function(name = "verifyWindowsEnrollmentAutoDiscovery")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> verifyWindowsEnrollmentAutoDiscovery(String domainName) {
        Preconditions.checkNotNull(domainName, "domainName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("domainName", "Edm.String", Checks.checkIsAscii(domainName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifyWindowsEnrollmentAutoDiscovery"), Boolean.class, _parameters);
    }

    @Function(name = "getComanagedDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary> getComanagedDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagedDevicesSummary"), ComanagedDevicesSummary.class, _parameters);
    }

    @Function(name = "getComanagementEligibleDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary> getComanagementEligibleDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagementEligibleDevicesSummary"), ComanagementEligibleDevicesSummary.class, _parameters);
    }

    @Function(name = "userExperienceAnalyticsSummarizeWorkFromAnywhereDevices")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsWorkFromAnywhereDevicesSummary> userExperienceAnalyticsSummarizeWorkFromAnywhereDevices() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserExperienceAnalyticsWorkFromAnywhereDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.userExperienceAnalyticsSummarizeWorkFromAnywhereDevices"), UserExperienceAnalyticsWorkFromAnywhereDevicesSummary.class, _parameters);
    }

    @Function(name = "getSuggestedEnrollmentLimit")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<SuggestedEnrollmentLimit> getSuggestedEnrollmentLimit(String enrollmentType) {
        Preconditions.checkNotNull(enrollmentType, "enrollmentType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enrollmentType", "Edm.String", Checks.checkIsAscii(enrollmentType))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<SuggestedEnrollmentLimit>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSuggestedEnrollmentLimit"), SuggestedEnrollmentLimit.class, _parameters);
    }

    @Function(name = "getAssignedRoleDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails> getAssignedRoleDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignedRoleDetails"), DeviceAndAppManagementAssignedRoleDetails.class, _parameters);
    }

    @Function(name = "getRoleScopeTagsByIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByIds(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByIds"), RoleScopeTag.class, _parameters);
    }

    @Function(name = "getRoleScopeTagsByResource")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByResource"), RoleScopeTag.class, _parameters);
    }

    @Function(name = "scopedForResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> scopedForResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scopedForResource"), Boolean.class, _parameters);
    }

}
