package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementSettingComparison;
import odata.msgraph.client.beta.entity.DeviceManagementIntent;
import odata.msgraph.client.beta.entity.DeviceManagementIntentAssignment;
import odata.msgraph.client.beta.entity.DeviceManagementSettingInstance;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentUserStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;

@JsonIgnoreType
public class DeviceManagementIntentRequest extends EntityRequest<DeviceManagementIntent> {

    public DeviceManagementIntentRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementIntent.class, contextPath, value, false);
    }

    public DeviceManagementIntentAssignmentRequest assignments(String id) {
        return new DeviceManagementIntentAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentAssignmentCollectionRequest assignments() {
        return new DeviceManagementIntentAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceManagementIntentSettingCategoryRequest categories(String id) {
        return new DeviceManagementIntentSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentSettingCategoryCollectionRequest categories() {
        return new DeviceManagementIntentSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"), Optional.empty());
    }

    public DeviceManagementIntentDeviceSettingStateSummaryRequest deviceSettingStateSummaries(String id) {
        return new DeviceManagementIntentDeviceSettingStateSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest deviceSettingStateSummaries() {
        return new DeviceManagementIntentDeviceSettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.empty());
    }

    public DeviceManagementIntentDeviceStateRequest deviceStates(String id) {
        return new DeviceManagementIntentDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentDeviceStateCollectionRequest deviceStates() {
        return new DeviceManagementIntentDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"), Optional.empty());
    }

    public DeviceManagementIntentDeviceStateSummaryRequest deviceStateSummary() {
        return new DeviceManagementIntentDeviceStateSummaryRequest(contextPath.addSegment("deviceStateSummary"), Optional.empty());
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"), Optional.empty());
    }

    public DeviceManagementIntentUserStateRequest userStates(String id) {
        return new DeviceManagementIntentUserStateRequest(contextPath.addSegment("userStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementIntentUserStateCollectionRequest userStates() {
        return new DeviceManagementIntentUserStateCollectionRequest(
                        contextPath.addSegment("userStates"), Optional.empty());
    }

    public DeviceManagementIntentUserStateSummaryRequest userStateSummary() {
        return new DeviceManagementIntentUserStateSummaryRequest(contextPath.addSegment("userStateSummary"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceManagementIntentAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceManagementIntentAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

    @Action(name = "createCopy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent> createCopy(String displayName, String description) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .put("description", "Edm.String", Checks.checkIsAscii(description))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DeviceManagementIntent>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createCopy"), DeviceManagementIntent.class, _parameters);
    }

    @Action(name = "migrateToTemplate")
    @JsonIgnore
    public ActionRequestNoReturn migrateToTemplate(String newTemplateId, Boolean preserveCustomValues) {
        Preconditions.checkNotNull(preserveCustomValues, "preserveCustomValues cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("newTemplateId", "Edm.String", Checks.checkIsAscii(newTemplateId))
            .put("preserveCustomValues", "Edm.Boolean", preserveCustomValues)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.migrateToTemplate"), _parameters);
    }

    @Action(name = "updateSettings")
    @JsonIgnore
    public ActionRequestNoReturn updateSettings(List<DeviceManagementSettingInstance> settings) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("settings", "Collection(microsoft.graph.deviceManagementSettingInstance)", settings)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateSettings"), _parameters);
    }

    @Function(name = "compare")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceManagementSettingComparison> compare(String templateId) {
        Preconditions.checkNotNull(templateId, "templateId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.compare"), DeviceManagementSettingComparison.class, _parameters);
    }

}
