package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementConfigurationPolicyTemplate;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementConfigurationSettingTemplateCollectionRequest;

@JsonIgnoreType
public class DeviceManagementConfigurationPolicyTemplateRequest extends EntityRequest<DeviceManagementConfigurationPolicyTemplate> {

    public DeviceManagementConfigurationPolicyTemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementConfigurationPolicyTemplate.class, contextPath, value, false);
    }

    public DeviceManagementConfigurationSettingTemplateRequest settingTemplates(String id) {
        return new DeviceManagementConfigurationSettingTemplateRequest(contextPath.addSegment("settingTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementConfigurationSettingTemplateCollectionRequest settingTemplates() {
        return new DeviceManagementConfigurationSettingTemplateCollectionRequest(
                        contextPath.addSegment("settingTemplates"), Optional.empty());
    }

}
