package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementComplianceActionItemCollectionRequest;

@JsonIgnoreType
public class DeviceManagementComplianceScheduledActionForRuleRequest extends EntityRequest<DeviceManagementComplianceScheduledActionForRule> {

    public DeviceManagementComplianceScheduledActionForRuleRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementComplianceScheduledActionForRule.class, contextPath, value, false);
    }

    public DeviceManagementComplianceActionItemRequest scheduledActionConfigurations(String id) {
        return new DeviceManagementComplianceActionItemRequest(contextPath.addSegment("scheduledActionConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementComplianceActionItemCollectionRequest scheduledActionConfigurations() {
        return new DeviceManagementComplianceActionItemCollectionRequest(
                        contextPath.addSegment("scheduledActionConfigurations"), Optional.empty());
    }

}
