package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceManagementComplexSettingInstance;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;

@JsonIgnoreType
public class DeviceManagementComplexSettingInstanceRequest extends EntityRequest<DeviceManagementComplexSettingInstance> {

    public DeviceManagementComplexSettingInstanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceManagementComplexSettingInstance.class, contextPath, value, false);
    }

    public DeviceManagementSettingInstanceRequest value(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("value").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceManagementSettingInstanceCollectionRequest value() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("value"), Optional.empty());
    }

}
