package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceConfiguration;
import odata.msgraph.client.beta.entity.DeviceConfigurationAssignment;
import odata.msgraph.client.beta.entity.DeviceConfigurationGroupAssignment;
import odata.msgraph.client.beta.entity.WindowsAssignedAccessProfile;
import odata.msgraph.client.beta.entity.WindowsPrivacyDataAccessControlItem;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;

@JsonIgnoreType
public class DeviceConfigurationRequest extends EntityRequest<DeviceConfiguration> {

    public DeviceConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceConfiguration.class, contextPath, value, false);
    }

    public DeviceConfigurationAssignmentRequest assignments(String id) {
        return new DeviceConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationAssignmentCollectionRequest assignments() {
        return new DeviceConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public SettingStateDeviceSummaryRequest deviceSettingStateSummaries(String id) {
        return new SettingStateDeviceSummaryRequest(contextPath.addSegment("deviceSettingStateSummaries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SettingStateDeviceSummaryCollectionRequest deviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.empty());
    }

    public DeviceConfigurationDeviceStatusRequest deviceStatuses(String id) {
        return new DeviceConfigurationDeviceStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationDeviceStatusCollectionRequest deviceStatuses() {
        return new DeviceConfigurationDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

    public DeviceConfigurationDeviceOverviewRequest deviceStatusOverview() {
        return new DeviceConfigurationDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"), Optional.empty());
    }

    public DeviceConfigurationGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceConfigurationGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceConfigurationGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"), Optional.empty());
    }

    public DeviceConfigurationUserStatusRequest userStatuses(String id) {
        return new DeviceConfigurationUserStatusRequest(contextPath.addSegment("userStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceConfigurationUserStatusCollectionRequest userStatuses() {
        return new DeviceConfigurationUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.empty());
    }

    public DeviceConfigurationUserOverviewRequest userStatusOverview() {
        return new DeviceConfigurationUserOverviewRequest(contextPath.addSegment("userStatusOverview"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceConfigurationAssignment> assign(List<DeviceConfigurationGroupAssignment> deviceConfigurationGroupAssignments, List<DeviceConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceConfigurationGroupAssignments", "Collection(microsoft.graph.deviceConfigurationGroupAssignment)", deviceConfigurationGroupAssignments)
            .put("assignments", "Collection(microsoft.graph.deviceConfigurationAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceConfigurationAssignment.class, _parameters);
    }

    @Action(name = "assignedAccessMultiModeProfiles")
    @JsonIgnore
    public ActionRequestNoReturn assignedAccessMultiModeProfiles(List<WindowsAssignedAccessProfile> assignedAccessMultiModeProfiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignedAccessMultiModeProfiles", "Collection(microsoft.graph.windowsAssignedAccessProfile)", assignedAccessMultiModeProfiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assignedAccessMultiModeProfiles"), _parameters);
    }

    @Action(name = "windowsPrivacyAccessControls")
    @JsonIgnore
    public ActionRequestNoReturn windowsPrivacyAccessControls(List<WindowsPrivacyDataAccessControlItem> windowsPrivacyAccessControls) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("windowsPrivacyAccessControls", "Collection(microsoft.graph.windowsPrivacyDataAccessControlItem)", windowsPrivacyAccessControls)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.windowsPrivacyAccessControls"), _parameters);
    }

    @Function(name = "getOmaSettingPlainTextValue")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getOmaSettingPlainTextValue(String secretReferenceValueId) {
        Preconditions.checkNotNull(secretReferenceValueId, "secretReferenceValueId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("secretReferenceValueId", "Edm.String", Checks.checkIsAscii(secretReferenceValueId))
            .build();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOmaSettingPlainTextValue"), String.class, _parameters);
    }

}
