package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceComplianceScript;
import odata.msgraph.client.beta.entity.DeviceHealthScriptAssignment;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptAssignmentCollectionRequest;

@JsonIgnoreType
public class DeviceComplianceScriptRequest extends EntityRequest<DeviceComplianceScript> {

    public DeviceComplianceScriptRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceComplianceScript.class, contextPath, value, false);
    }

    public DeviceHealthScriptAssignmentRequest assignments(String id) {
        return new DeviceHealthScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceHealthScriptAssignmentCollectionRequest assignments() {
        return new DeviceHealthScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.empty());
    }

    public DeviceComplianceScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceComplianceScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceComplianceScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"), Optional.empty());
    }

    public DeviceComplianceScriptRunSummaryRequest runSummary() {
        return new DeviceComplianceScriptRunSummaryRequest(contextPath.addSegment("runSummary"), Optional.empty());
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceHealthScriptAssignment> deviceHealthScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceHealthScriptAssignments", "Collection(microsoft.graph.deviceHealthScriptAssignment)", deviceHealthScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
