package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceComplianceScheduledActionForRule;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceActionItemCollectionRequest;

@JsonIgnoreType
public class DeviceComplianceScheduledActionForRuleRequest extends EntityRequest<DeviceComplianceScheduledActionForRule> {

    public DeviceComplianceScheduledActionForRuleRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceComplianceScheduledActionForRule.class, contextPath, value, false);
    }

    public DeviceComplianceActionItemRequest scheduledActionConfigurations(String id) {
        return new DeviceComplianceActionItemRequest(contextPath.addSegment("scheduledActionConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceActionItemCollectionRequest scheduledActionConfigurations() {
        return new DeviceComplianceActionItemCollectionRequest(
                        contextPath.addSegment("scheduledActionConfigurations"), Optional.empty());
    }

}
