package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceCompliancePolicySettingStateSummary;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceSettingStateCollectionRequest;

@JsonIgnoreType
public class DeviceCompliancePolicySettingStateSummaryRequest extends EntityRequest<DeviceCompliancePolicySettingStateSummary> {

    public DeviceCompliancePolicySettingStateSummaryRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceCompliancePolicySettingStateSummary.class, contextPath, value, false);
    }

    public DeviceComplianceSettingStateRequest deviceComplianceSettingStates(String id) {
        return new DeviceComplianceSettingStateRequest(contextPath.addSegment("deviceComplianceSettingStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceComplianceSettingStateCollectionRequest deviceComplianceSettingStates() {
        return new DeviceComplianceSettingStateCollectionRequest(
                        contextPath.addSegment("deviceComplianceSettingStates"), Optional.empty());
    }

}
