package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceAppManagementTask;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskStatus;

@JsonIgnoreType
public class DeviceAppManagementTaskRequest extends EntityRequest<DeviceAppManagementTask> {

    public DeviceAppManagementTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceAppManagementTask.class, contextPath, value, false);
    }

    @Action(name = "updateStatus")
    @JsonIgnore
    public ActionRequestNoReturn updateStatus(DeviceAppManagementTaskStatus status, String note) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "microsoft.graph.deviceAppManagementTaskStatus", status)
            .put("note", "Edm.String", Checks.checkIsAscii(note))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateStatus"), _parameters);
    }

}
