package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DeviceAndAppManagementRoleAssignment;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;

@JsonIgnoreType
public class DeviceAndAppManagementRoleAssignmentRequest extends EntityRequest<DeviceAndAppManagementRoleAssignment> {

    public DeviceAndAppManagementRoleAssignmentRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceAndAppManagementRoleAssignment.class, contextPath, value, false);
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"), Optional.empty());
    }

}
