package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AssignmentFilterSupportedProperty;
import odata.msgraph.client.beta.entity.DeviceAndAppManagementAssignmentFilter;

@JsonIgnoreType
public class DeviceAndAppManagementAssignmentFilterRequest extends EntityRequest<DeviceAndAppManagementAssignmentFilter> {

    public DeviceAndAppManagementAssignmentFilterRequest(ContextPath contextPath, Optional<Object> value) {
        super(DeviceAndAppManagementAssignmentFilter.class, contextPath, value, false);
    }

    @Function(name = "getSupportedProperties")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AssignmentFilterSupportedProperty> getSupportedProperties() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSupportedProperties"), AssignmentFilterSupportedProperty.class, _parameters);
    }

}
