package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.DelegatedAdminCustomer;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminServiceManagementDetailCollectionRequest;

@JsonIgnoreType
public class DelegatedAdminCustomerRequest extends EntityRequest<DelegatedAdminCustomer> {

    public DelegatedAdminCustomerRequest(ContextPath contextPath, Optional<Object> value) {
        super(DelegatedAdminCustomer.class, contextPath, value, false);
    }

    public DelegatedAdminServiceManagementDetailRequest serviceManagementDetails(String id) {
        return new DelegatedAdminServiceManagementDetailRequest(contextPath.addSegment("serviceManagementDetails").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DelegatedAdminServiceManagementDetailCollectionRequest serviceManagementDetails() {
        return new DelegatedAdminServiceManagementDetailCollectionRequest(
                        contextPath.addSegment("serviceManagementDetails"), Optional.empty());
    }

}
