package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CustomSecurityAttributeDefinition;
import odata.msgraph.client.beta.entity.collection.request.AllowedValueCollectionRequest;

@JsonIgnoreType
public class CustomSecurityAttributeDefinitionRequest extends EntityRequest<CustomSecurityAttributeDefinition> {

    public CustomSecurityAttributeDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(CustomSecurityAttributeDefinition.class, contextPath, value, false);
    }

    public AllowedValueRequest allowedValues(String id) {
        return new AllowedValueRequest(contextPath.addSegment("allowedValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AllowedValueCollectionRequest allowedValues() {
        return new AllowedValueCollectionRequest(
                        contextPath.addSegment("allowedValues"), Optional.empty());
    }

}
