package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CrossTenantAccessPolicy;
import odata.msgraph.client.beta.entity.collection.request.CrossTenantAccessPolicyConfigurationPartnerCollectionRequest;

@JsonIgnoreType
public class CrossTenantAccessPolicyRequest extends EntityRequest<CrossTenantAccessPolicy> {

    public CrossTenantAccessPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(CrossTenantAccessPolicy.class, contextPath, value, false);
    }

    public CrossTenantAccessPolicyConfigurationDefaultRequest default_() {
        return new CrossTenantAccessPolicyConfigurationDefaultRequest(contextPath.addSegment("default"), Optional.empty());
    }

    public CrossTenantAccessPolicyConfigurationPartnerRequest partners(String id) {
        return new CrossTenantAccessPolicyConfigurationPartnerRequest(contextPath.addSegment("partners").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CrossTenantAccessPolicyConfigurationPartnerCollectionRequest partners() {
        return new CrossTenantAccessPolicyConfigurationPartnerCollectionRequest(
                        contextPath.addSegment("partners"), Optional.empty());
    }

}
