package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Conversation;
import odata.msgraph.client.beta.entity.collection.request.ConversationThreadCollectionRequest;

@JsonIgnoreType
public class ConversationRequest extends EntityRequest<Conversation> {

    public ConversationRequest(ContextPath contextPath, Optional<Object> value) {
        super(Conversation.class, contextPath, value, false);
    }

    public ConversationThreadRequest threads(String id) {
        return new ConversationThreadRequest(contextPath.addSegment("threads").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationThreadCollectionRequest threads() {
        return new ConversationThreadCollectionRequest(
                        contextPath.addSegment("threads"), Optional.empty());
    }

}
