package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.entity.ContentType;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ColumnLinkCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;

@JsonIgnoreType
public class ContentTypeRequest extends EntityRequest<ContentType> {

    public ContentTypeRequest(ContextPath contextPath, Optional<Object> value) {
        super(ContentType.class, contextPath, value, false);
    }

    public ContentTypeRequest base() {
        return new ContentTypeRequest(contextPath.addSegment("base"), Optional.empty());
    }

    public ContentTypeRequest baseTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("baseTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest baseTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("baseTypes"), Optional.empty());
    }

    public ColumnLinkRequest columnLinks(String id) {
        return new ColumnLinkRequest(contextPath.addSegment("columnLinks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnLinkCollectionRequest columnLinks() {
        return new ColumnLinkCollectionRequest(
                        contextPath.addSegment("columnLinks"), Optional.empty());
    }

    public ColumnDefinitionRequest columnPositions(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columnPositions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columnPositions() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columnPositions"), Optional.empty());
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.empty());
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

    @Action(name = "unpublish")
    @JsonIgnore
    public ActionRequestNoReturn unpublish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unpublish"), _parameters);
    }

    @Action(name = "associateWithHubSites")
    @JsonIgnore
    public ActionRequestNoReturn associateWithHubSites(List<String> hubSiteUrls, Boolean propagateToExistingLists) {
        Preconditions.checkNotNull(hubSiteUrls, "hubSiteUrls cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hubSiteUrls", "Collection(Edm.String)", Checks.checkIsAscii(hubSiteUrls))
            .put("propagateToExistingLists", "Edm.Boolean", propagateToExistingLists)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.associateWithHubSites"), _parameters);
    }

    @Action(name = "copyToDefaultContentLocation")
    @JsonIgnore
    public ActionRequestNoReturn copyToDefaultContentLocation(ItemReference sourceFile, String destinationFileName) {
        Preconditions.checkNotNull(sourceFile, "sourceFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceFile", "microsoft.graph.itemReference", sourceFile)
            .put("destinationFileName", "Edm.String", Checks.checkIsAscii(destinationFileName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToDefaultContentLocation"), _parameters);
    }

    @Function(name = "isPublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isPublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isPublished"), Boolean.class, _parameters);
    }

}
