package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Contact;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonIgnoreType
public class ContactRequest extends EntityRequest<Contact> {

    public ContactRequest(ContextPath contextPath, Optional<Object> value) {
        super(Contact.class, contextPath, value, false);
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.empty());
    }

    public ProfilePhotoRequest photo() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.empty());
    }

}
