package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Connector;
import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;

@JsonIgnoreType
public class ConnectorRequest extends EntityRequest<Connector> {

    public ConnectorRequest(ContextPath contextPath, Optional<Object> value) {
        super(Connector.class, contextPath, value, false);
    }

    public ConnectorGroupRequest memberOf(String id) {
        return new ConnectorGroupRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorGroupCollectionRequest memberOf() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("memberOf"), Optional.empty());
    }

}
