package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConnectorGroup;
import odata.msgraph.client.beta.entity.collection.request.ApplicationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectorCollectionRequest;

@JsonIgnoreType
public class ConnectorGroupRequest extends EntityRequest<ConnectorGroup> {

    public ConnectorGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(ConnectorGroup.class, contextPath, value, false);
    }

    public ApplicationRequest applications(String id) {
        return new ApplicationRequest(contextPath.addSegment("applications").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ApplicationCollectionRequest applications() {
        return new ApplicationCollectionRequest(
                        contextPath.addSegment("applications"), Optional.empty());
    }

    public ConnectorRequest members(String id) {
        return new ConnectorRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConnectorCollectionRequest members() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

}
