package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConnectedOrganization;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;

@JsonIgnoreType
public class ConnectedOrganizationRequest extends EntityRequest<ConnectedOrganization> {

    public ConnectedOrganizationRequest(ContextPath contextPath, Optional<Object> value) {
        super(ConnectedOrganization.class, contextPath, value, false);
    }

    public DirectoryObjectRequest externalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("externalSponsors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest externalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("externalSponsors"), Optional.empty());
    }

    public DirectoryObjectRequest internalSponsors(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("internalSponsors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest internalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("internalSponsors"), Optional.empty());
    }

}
