package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ConditionalAccessRoot;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationContextClassReferenceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConditionalAccessPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NamedLocationCollectionRequest;

@JsonIgnoreType
public class ConditionalAccessRootRequest extends EntityRequest<ConditionalAccessRoot> {

    public ConditionalAccessRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(ConditionalAccessRoot.class, contextPath, value, false);
    }

    public AuthenticationContextClassReferenceRequest authenticationContextClassReferences(String id) {
        return new AuthenticationContextClassReferenceRequest(contextPath.addSegment("authenticationContextClassReferences").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationContextClassReferenceCollectionRequest authenticationContextClassReferences() {
        return new AuthenticationContextClassReferenceCollectionRequest(
                        contextPath.addSegment("authenticationContextClassReferences"), Optional.empty());
    }

    public NamedLocationRequest namedLocations(String id) {
        return new NamedLocationRequest(contextPath.addSegment("namedLocations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public NamedLocationCollectionRequest namedLocations() {
        return new NamedLocationCollectionRequest(
                        contextPath.addSegment("namedLocations"), Optional.empty());
    }

    public ConditionalAccessPolicyRequest policies(String id) {
        return new ConditionalAccessPolicyRequest(contextPath.addSegment("policies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConditionalAccessPolicyCollectionRequest policies() {
        return new ConditionalAccessPolicyCollectionRequest(
                        contextPath.addSegment("policies"), Optional.empty());
    }

}
