package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Company;
import odata.msgraph.client.beta.entity.collection.request.AccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsPayableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgedAccountsReceivableCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CompanyInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CountryRegionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CurrencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CustomerPaymentJournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DimensionValueCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmployeeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GeneralLedgerEntryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.JournalLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PaymentTermCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PictureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteLineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShipmentMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxAreaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TaxGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnitOfMeasureCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.VendorCollectionRequest;

@JsonIgnoreType
public class CompanyRequest extends EntityRequest<Company> {

    public CompanyRequest(ContextPath contextPath, Optional<Object> value) {
        super(Company.class, contextPath, value, false);
    }

    public AccountRequest accounts(String id) {
        return new AccountRequest(contextPath.addSegment("accounts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccountCollectionRequest accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("accounts"), Optional.empty());
    }

    public AgedAccountsPayableRequest agedAccountsPayable(String id) {
        return new AgedAccountsPayableRequest(contextPath.addSegment("agedAccountsPayable").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgedAccountsPayableCollectionRequest agedAccountsPayable() {
        return new AgedAccountsPayableCollectionRequest(
                        contextPath.addSegment("agedAccountsPayable"), Optional.empty());
    }

    public AgedAccountsReceivableRequest agedAccountsReceivable(String id) {
        return new AgedAccountsReceivableRequest(contextPath.addSegment("agedAccountsReceivable").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgedAccountsReceivableCollectionRequest agedAccountsReceivable() {
        return new AgedAccountsReceivableCollectionRequest(
                        contextPath.addSegment("agedAccountsReceivable"), Optional.empty());
    }

    public CompanyInformationRequest companyInformation(String id) {
        return new CompanyInformationRequest(contextPath.addSegment("companyInformation").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CompanyInformationCollectionRequest companyInformation() {
        return new CompanyInformationCollectionRequest(
                        contextPath.addSegment("companyInformation"), Optional.empty());
    }

    public CountryRegionRequest countriesRegions(String id) {
        return new CountryRegionRequest(contextPath.addSegment("countriesRegions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CountryRegionCollectionRequest countriesRegions() {
        return new CountryRegionCollectionRequest(
                        contextPath.addSegment("countriesRegions"), Optional.empty());
    }

    public CurrencyRequest currencies(String id) {
        return new CurrencyRequest(contextPath.addSegment("currencies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CurrencyCollectionRequest currencies() {
        return new CurrencyCollectionRequest(
                        contextPath.addSegment("currencies"), Optional.empty());
    }

    public CustomerPaymentJournalRequest customerPaymentJournals(String id) {
        return new CustomerPaymentJournalRequest(contextPath.addSegment("customerPaymentJournals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomerPaymentJournalCollectionRequest customerPaymentJournals() {
        return new CustomerPaymentJournalCollectionRequest(
                        contextPath.addSegment("customerPaymentJournals"), Optional.empty());
    }

    public CustomerPaymentRequest customerPayments(String id) {
        return new CustomerPaymentRequest(contextPath.addSegment("customerPayments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomerPaymentCollectionRequest customerPayments() {
        return new CustomerPaymentCollectionRequest(
                        contextPath.addSegment("customerPayments"), Optional.empty());
    }

    public CustomerRequest customers(String id) {
        return new CustomerRequest(contextPath.addSegment("customers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CustomerCollectionRequest customers() {
        return new CustomerCollectionRequest(
                        contextPath.addSegment("customers"), Optional.empty());
    }

    public DimensionRequest dimensions(String id) {
        return new DimensionRequest(contextPath.addSegment("dimensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DimensionCollectionRequest dimensions() {
        return new DimensionCollectionRequest(
                        contextPath.addSegment("dimensions"), Optional.empty());
    }

    public DimensionValueRequest dimensionValues(String id) {
        return new DimensionValueRequest(contextPath.addSegment("dimensionValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DimensionValueCollectionRequest dimensionValues() {
        return new DimensionValueCollectionRequest(
                        contextPath.addSegment("dimensionValues"), Optional.empty());
    }

    public EmployeeRequest employees(String id) {
        return new EmployeeRequest(contextPath.addSegment("employees").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public EmployeeCollectionRequest employees() {
        return new EmployeeCollectionRequest(
                        contextPath.addSegment("employees"), Optional.empty());
    }

    public GeneralLedgerEntryRequest generalLedgerEntries(String id) {
        return new GeneralLedgerEntryRequest(contextPath.addSegment("generalLedgerEntries").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GeneralLedgerEntryCollectionRequest generalLedgerEntries() {
        return new GeneralLedgerEntryCollectionRequest(
                        contextPath.addSegment("generalLedgerEntries"), Optional.empty());
    }

    public ItemCategoryRequest itemCategories(String id) {
        return new ItemCategoryRequest(contextPath.addSegment("itemCategories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemCategoryCollectionRequest itemCategories() {
        return new ItemCategoryCollectionRequest(
                        contextPath.addSegment("itemCategories"), Optional.empty());
    }

    public ItemRequest items(String id) {
        return new ItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ItemCollectionRequest items() {
        return new ItemCollectionRequest(
                        contextPath.addSegment("items"), Optional.empty());
    }

    public JournalLineRequest journalLines(String id) {
        return new JournalLineRequest(contextPath.addSegment("journalLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JournalLineCollectionRequest journalLines() {
        return new JournalLineCollectionRequest(
                        contextPath.addSegment("journalLines"), Optional.empty());
    }

    public JournalRequest journals(String id) {
        return new JournalRequest(contextPath.addSegment("journals").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public JournalCollectionRequest journals() {
        return new JournalCollectionRequest(
                        contextPath.addSegment("journals"), Optional.empty());
    }

    public PaymentMethodRequest paymentMethods(String id) {
        return new PaymentMethodRequest(contextPath.addSegment("paymentMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PaymentMethodCollectionRequest paymentMethods() {
        return new PaymentMethodCollectionRequest(
                        contextPath.addSegment("paymentMethods"), Optional.empty());
    }

    public PaymentTermRequest paymentTerms(String id) {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerms").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PaymentTermCollectionRequest paymentTerms() {
        return new PaymentTermCollectionRequest(
                        contextPath.addSegment("paymentTerms"), Optional.empty());
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(
                        contextPath.addSegment("picture"), Optional.empty());
    }

    public PurchaseInvoiceLineRequest purchaseInvoiceLines(String id) {
        return new PurchaseInvoiceLineRequest(contextPath.addSegment("purchaseInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PurchaseInvoiceLineCollectionRequest purchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"), Optional.empty());
    }

    public PurchaseInvoiceRequest purchaseInvoices(String id) {
        return new PurchaseInvoiceRequest(contextPath.addSegment("purchaseInvoices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PurchaseInvoiceCollectionRequest purchaseInvoices() {
        return new PurchaseInvoiceCollectionRequest(
                        contextPath.addSegment("purchaseInvoices"), Optional.empty());
    }

    public SalesCreditMemoLineRequest salesCreditMemoLines(String id) {
        return new SalesCreditMemoLineRequest(contextPath.addSegment("salesCreditMemoLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesCreditMemoLineCollectionRequest salesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(
                        contextPath.addSegment("salesCreditMemoLines"), Optional.empty());
    }

    public SalesCreditMemoRequest salesCreditMemos(String id) {
        return new SalesCreditMemoRequest(contextPath.addSegment("salesCreditMemos").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesCreditMemoCollectionRequest salesCreditMemos() {
        return new SalesCreditMemoCollectionRequest(
                        contextPath.addSegment("salesCreditMemos"), Optional.empty());
    }

    public SalesInvoiceLineRequest salesInvoiceLines(String id) {
        return new SalesInvoiceLineRequest(contextPath.addSegment("salesInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesInvoiceLineCollectionRequest salesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"), Optional.empty());
    }

    public SalesInvoiceRequest salesInvoices(String id) {
        return new SalesInvoiceRequest(contextPath.addSegment("salesInvoices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesInvoiceCollectionRequest salesInvoices() {
        return new SalesInvoiceCollectionRequest(
                        contextPath.addSegment("salesInvoices"), Optional.empty());
    }

    public SalesOrderLineRequest salesOrderLines(String id) {
        return new SalesOrderLineRequest(contextPath.addSegment("salesOrderLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesOrderLineCollectionRequest salesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"), Optional.empty());
    }

    public SalesOrderRequest salesOrders(String id) {
        return new SalesOrderRequest(contextPath.addSegment("salesOrders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesOrderCollectionRequest salesOrders() {
        return new SalesOrderCollectionRequest(
                        contextPath.addSegment("salesOrders"), Optional.empty());
    }

    public SalesQuoteLineRequest salesQuoteLines(String id) {
        return new SalesQuoteLineRequest(contextPath.addSegment("salesQuoteLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesQuoteLineCollectionRequest salesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(
                        contextPath.addSegment("salesQuoteLines"), Optional.empty());
    }

    public SalesQuoteRequest salesQuotes(String id) {
        return new SalesQuoteRequest(contextPath.addSegment("salesQuotes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesQuoteCollectionRequest salesQuotes() {
        return new SalesQuoteCollectionRequest(
                        contextPath.addSegment("salesQuotes"), Optional.empty());
    }

    public ShipmentMethodRequest shipmentMethods(String id) {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethods").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ShipmentMethodCollectionRequest shipmentMethods() {
        return new ShipmentMethodCollectionRequest(
                        contextPath.addSegment("shipmentMethods"), Optional.empty());
    }

    public TaxAreaRequest taxAreas(String id) {
        return new TaxAreaRequest(contextPath.addSegment("taxAreas").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TaxAreaCollectionRequest taxAreas() {
        return new TaxAreaCollectionRequest(
                        contextPath.addSegment("taxAreas"), Optional.empty());
    }

    public TaxGroupRequest taxGroups(String id) {
        return new TaxGroupRequest(contextPath.addSegment("taxGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TaxGroupCollectionRequest taxGroups() {
        return new TaxGroupCollectionRequest(
                        contextPath.addSegment("taxGroups"), Optional.empty());
    }

    public UnitOfMeasureRequest unitsOfMeasure(String id) {
        return new UnitOfMeasureRequest(contextPath.addSegment("unitsOfMeasure").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnitOfMeasureCollectionRequest unitsOfMeasure() {
        return new UnitOfMeasureCollectionRequest(
                        contextPath.addSegment("unitsOfMeasure"), Optional.empty());
    }

    public VendorRequest vendors(String id) {
        return new VendorRequest(contextPath.addSegment("vendors").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public VendorCollectionRequest vendors() {
        return new VendorCollectionRequest(
                        contextPath.addSegment("vendors"), Optional.empty());
    }

}
