package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CommsApplication;
import odata.msgraph.client.beta.entity.collection.request.CallCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OnlineMeetingCollectionRequest;

@JsonIgnoreType
public class CommsApplicationRequest extends EntityRequest<CommsApplication> {

    public CommsApplicationRequest(ContextPath contextPath, Optional<Object> value) {
        super(CommsApplication.class, contextPath, value, false);
    }

    public CallRequest calls(String id) {
        return new CallRequest(contextPath.addSegment("calls").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CallCollectionRequest calls() {
        return new CallCollectionRequest(
                        contextPath.addSegment("calls"), Optional.empty());
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(
                        contextPath.addSegment("onlineMeetings"), Optional.empty());
    }

}
