package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ItemBody;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.TeamworkActivityTopic;
import odata.msgraph.client.beta.complex.TeamworkNotificationRecipient;
import odata.msgraph.client.beta.complex.TeamworkUserIdentity;
import odata.msgraph.client.beta.entity.Chat;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceSpecificPermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAppInstallationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsAsyncOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;

@JsonIgnoreType
public class ChatRequest extends EntityRequest<Chat> {

    public ChatRequest(ContextPath contextPath, Optional<Object> value) {
        super(Chat.class, contextPath, value, false);
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(
                        contextPath.addSegment("installedApps"), Optional.empty());
    }

    public ChatMessageInfoRequest lastMessagePreview() {
        return new ChatMessageInfoRequest(contextPath.addSegment("lastMessagePreview"), Optional.empty());
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.empty());
    }

    public ChatMessageRequest messages(String id) {
        return new ChatMessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ChatMessageCollectionRequest messages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.empty());
    }

    public TeamsAsyncOperationRequest operations(String id) {
        return new TeamsAsyncOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsAsyncOperationCollectionRequest operations() {
        return new TeamsAsyncOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.empty());
    }

    public ResourceSpecificPermissionGrantRequest permissionGrants(String id) {
        return new ResourceSpecificPermissionGrantRequest(contextPath.addSegment("permissionGrants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ResourceSpecificPermissionGrantCollectionRequest permissionGrants() {
        return new ResourceSpecificPermissionGrantCollectionRequest(
                        contextPath.addSegment("permissionGrants"), Optional.empty());
    }

    public TeamsTabRequest tabs(String id) {
        return new TeamsTabRequest(contextPath.addSegment("tabs").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TeamsTabCollectionRequest tabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"), Optional.empty());
    }

    @Action(name = "sendActivityNotification")
    @JsonIgnore
    public ActionRequestNoReturn sendActivityNotification(TeamworkActivityTopic topic, String activityType, Long chainId, ItemBody previewText, List<KeyValuePair> templateParameters, TeamworkNotificationRecipient recipient) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("topic", "microsoft.graph.teamworkActivityTopic", topic)
            .put("activityType", "Edm.String", Checks.checkIsAscii(activityType))
            .put("chainId", "Edm.Int64", chainId)
            .put("previewText", "microsoft.graph.itemBody", previewText)
            .put("templateParameters", "Collection(microsoft.graph.keyValuePair)", templateParameters)
            .put("recipient", "microsoft.graph.teamworkNotificationRecipient", recipient)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendActivityNotification"), _parameters);
    }

    @Action(name = "hideForUser")
    @JsonIgnore
    public ActionRequestNoReturn hideForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hideForUser"), _parameters);
    }

    @Action(name = "markChatReadForUser")
    @JsonIgnore
    public ActionRequestNoReturn markChatReadForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markChatReadForUser"), _parameters);
    }

    @Action(name = "markChatUnreadForUser")
    @JsonIgnore
    public ActionRequestNoReturn markChatUnreadForUser(TeamworkUserIdentity user, String tenantId, OffsetDateTime lastMessageReadDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .put("lastMessageReadDateTime", "Edm.DateTimeOffset", lastMessageReadDateTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markChatUnreadForUser"), _parameters);
    }

    @Action(name = "unhideForUser")
    @JsonIgnore
    public ActionRequestNoReturn unhideForUser(TeamworkUserIdentity user, String tenantId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("user", "microsoft.graph.teamworkUserIdentity", user)
            .put("tenantId", "Edm.String", Checks.checkIsAscii(tenantId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unhideForUser"), _parameters);
    }

}
