package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.CalendarGroup;
import odata.msgraph.client.beta.entity.collection.request.CalendarCollectionRequest;

@JsonIgnoreType
public class CalendarGroupRequest extends EntityRequest<CalendarGroup> {

    public CalendarGroupRequest(ContextPath contextPath, Optional<Object> value) {
        super(CalendarGroup.class, contextPath, value, false);
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("calendars"), Optional.empty());
    }

}
