package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BaseTaskList;
import odata.msgraph.client.beta.entity.collection.request.BaseTaskCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;

@JsonIgnoreType
public class BaseTaskListRequest extends EntityRequest<BaseTaskList> {

    public BaseTaskListRequest(ContextPath contextPath, Optional<Object> value) {
        super(BaseTaskList.class, contextPath, value, false);
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.empty());
    }

    public BaseTaskRequest tasks(String id) {
        return new BaseTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseTaskCollectionRequest tasks() {
        return new BaseTaskCollectionRequest(
                        contextPath.addSegment("tasks"), Optional.empty());
    }

}
