package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.BaseItem;

@JsonIgnoreType
public class BaseItemRequest extends EntityRequest<BaseItem> {

    public BaseItemRequest(ContextPath contextPath, Optional<Object> value) {
        super(BaseItem.class, contextPath, value, false);
    }

    public UserRequest createdByUser() {
        return new UserRequest(contextPath.addSegment("createdByUser"), Optional.empty());
    }

    public UserRequest lastModifiedByUser() {
        return new UserRequest(contextPath.addSegment("lastModifiedByUser"), Optional.empty());
    }

}
