package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuthorizationPolicy;
import odata.msgraph.client.beta.entity.collection.request.DefaultUserRoleOverrideCollectionRequest;

@JsonIgnoreType
public class AuthorizationPolicyRequest extends EntityRequest<AuthorizationPolicy> {

    public AuthorizationPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuthorizationPolicy.class, contextPath, value, false);
    }

    public DefaultUserRoleOverrideRequest defaultUserRoleOverrides(String id) {
        return new DefaultUserRoleOverrideRequest(contextPath.addSegment("defaultUserRoleOverrides").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DefaultUserRoleOverrideCollectionRequest defaultUserRoleOverrides() {
        return new DefaultUserRoleOverrideCollectionRequest(
                        contextPath.addSegment("defaultUserRoleOverrides"), Optional.empty());
    }

}
