package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuthenticationMethodsPolicy;
import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodConfigurationCollectionRequest;

@JsonIgnoreType
public class AuthenticationMethodsPolicyRequest extends EntityRequest<AuthenticationMethodsPolicy> {

    public AuthenticationMethodsPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuthenticationMethodsPolicy.class, contextPath, value, false);
    }

    public AuthenticationMethodConfigurationRequest authenticationMethodConfigurations(String id) {
        return new AuthenticationMethodConfigurationRequest(contextPath.addSegment("authenticationMethodConfigurations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthenticationMethodConfigurationCollectionRequest authenticationMethodConfigurations() {
        return new AuthenticationMethodConfigurationCollectionRequest(
                        contextPath.addSegment("authenticationMethodConfigurations"), Optional.empty());
    }

}
