package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AuditLogRoot;
import odata.msgraph.client.beta.entity.collection.request.DirectoryAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProvisioningObjectSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedSignInCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SignInCollectionRequest;

@JsonIgnoreType
public class AuditLogRootRequest extends EntityRequest<AuditLogRoot> {

    public AuditLogRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(AuditLogRoot.class, contextPath, value, false);
    }

    public DirectoryAuditRequest directoryAudits(String id) {
        return new DirectoryAuditRequest(contextPath.addSegment("directoryAudits").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryAuditCollectionRequest directoryAudits() {
        return new DirectoryAuditCollectionRequest(
                        contextPath.addSegment("directoryAudits"), Optional.empty());
    }

    public ProvisioningObjectSummaryRequest directoryProvisioning(String id) {
        return new ProvisioningObjectSummaryRequest(contextPath.addSegment("directoryProvisioning").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProvisioningObjectSummaryCollectionRequest directoryProvisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("directoryProvisioning"), Optional.empty());
    }

    public ProvisioningObjectSummaryRequest provisioning(String id) {
        return new ProvisioningObjectSummaryRequest(contextPath.addSegment("provisioning").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ProvisioningObjectSummaryCollectionRequest provisioning() {
        return new ProvisioningObjectSummaryCollectionRequest(
                        contextPath.addSegment("provisioning"), Optional.empty());
    }

    public RestrictedSignInRequest restrictedSignIns(String id) {
        return new RestrictedSignInRequest(contextPath.addSegment("restrictedSignIns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RestrictedSignInCollectionRequest restrictedSignIns() {
        return new RestrictedSignInCollectionRequest(
                        contextPath.addSegment("restrictedSignIns"), Optional.empty());
    }

    public SignInRequest signIns(String id) {
        return new SignInRequest(contextPath.addSegment("signIns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SignInCollectionRequest signIns() {
        return new SignInCollectionRequest(
                        contextPath.addSegment("signIns"), Optional.empty());
    }

}
