package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AttackSimulationRoot;
import odata.msgraph.client.beta.entity.collection.request.SimulationAutomationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SimulationCollectionRequest;

@JsonIgnoreType
public class AttackSimulationRootRequest extends EntityRequest<AttackSimulationRoot> {

    public AttackSimulationRootRequest(ContextPath contextPath, Optional<Object> value) {
        super(AttackSimulationRoot.class, contextPath, value, false);
    }

    public SimulationAutomationRequest simulationAutomations(String id) {
        return new SimulationAutomationRequest(contextPath.addSegment("simulationAutomations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SimulationAutomationCollectionRequest simulationAutomations() {
        return new SimulationAutomationCollectionRequest(
                        contextPath.addSegment("simulationAutomations"), Optional.empty());
    }

    public SimulationRequest simulations(String id) {
        return new SimulationRequest(contextPath.addSegment("simulations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SimulationCollectionRequest simulations() {
        return new SimulationCollectionRequest(
                        contextPath.addSegment("simulations"), Optional.empty());
    }

}
