package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ApprovalWorkflowProvider;
import odata.msgraph.client.beta.entity.collection.request.BusinessFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernancePolicyTemplateCollectionRequest;

@JsonIgnoreType
public class ApprovalWorkflowProviderRequest extends EntityRequest<ApprovalWorkflowProvider> {

    public ApprovalWorkflowProviderRequest(ContextPath contextPath, Optional<Object> value) {
        super(ApprovalWorkflowProvider.class, contextPath, value, false);
    }

    public BusinessFlowRequest businessFlows(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlows").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BusinessFlowCollectionRequest businessFlows() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlows"), Optional.empty());
    }

    public BusinessFlowRequest businessFlowsWithRequestsAwaitingMyDecision(String id) {
        return new BusinessFlowRequest(contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BusinessFlowCollectionRequest businessFlowsWithRequestsAwaitingMyDecision() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision"), Optional.empty());
    }

    public GovernancePolicyTemplateRequest policyTemplates(String id) {
        return new GovernancePolicyTemplateRequest(contextPath.addSegment("policyTemplates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GovernancePolicyTemplateCollectionRequest policyTemplates() {
        return new GovernancePolicyTemplateCollectionRequest(
                        contextPath.addSegment("policyTemplates"), Optional.empty());
    }

}
