package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ApplicationServicePrincipal;
import odata.msgraph.client.beta.entity.ApplicationTemplate;

@JsonIgnoreType
public class ApplicationTemplateRequest extends EntityRequest<ApplicationTemplate> {

    public ApplicationTemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(ApplicationTemplate.class, contextPath, value, false);
    }

    @Action(name = "instantiate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ApplicationServicePrincipal> instantiate(String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ApplicationServicePrincipal>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.instantiate"), ApplicationServicePrincipal.class, _parameters);
    }

}
