package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ApplePushNotificationCertificate;

@JsonIgnoreType
public class ApplePushNotificationCertificateRequest extends EntityRequest<ApplePushNotificationCertificate> {

    public ApplePushNotificationCertificateRequest(ContextPath contextPath, Optional<Object> value) {
        super(ApplePushNotificationCertificate.class, contextPath, value, false);
    }

    @Action(name = "generateApplePushNotificationCertificateSigningRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> generateApplePushNotificationCertificateSigningRequest() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateApplePushNotificationCertificateSigningRequest"), String.class, _parameters);
    }

    @Function(name = "downloadApplePushNotificationCertificateSigningRequest")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> downloadApplePushNotificationCertificateSigningRequest() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.downloadApplePushNotificationCertificateSigningRequest"), String.class, _parameters);
    }

}
