package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppVulnerabilityTask;
import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityMobileAppCollectionRequest;

@JsonIgnoreType
public class AppVulnerabilityTaskRequest extends EntityRequest<AppVulnerabilityTask> {

    public AppVulnerabilityTaskRequest(ContextPath contextPath, Optional<Object> value) {
        super(AppVulnerabilityTask.class, contextPath, value, false);
    }

    public AppVulnerabilityManagedDeviceRequest managedDevices(String id) {
        return new AppVulnerabilityManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppVulnerabilityManagedDeviceCollectionRequest managedDevices() {
        return new AppVulnerabilityManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), Optional.empty());
    }

    public AppVulnerabilityMobileAppRequest mobileApps(String id) {
        return new AppVulnerabilityMobileAppRequest(contextPath.addSegment("mobileApps").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppVulnerabilityMobileAppCollectionRequest mobileApps() {
        return new AppVulnerabilityMobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"), Optional.empty());
    }

}
