package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppManagementPolicy;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;

@JsonIgnoreType
public class AppManagementPolicyRequest extends EntityRequest<AppManagementPolicy> {

    public AppManagementPolicyRequest(ContextPath contextPath, Optional<Object> value) {
        super(AppManagementPolicy.class, contextPath, value, false);
    }

    public DirectoryObjectRequest appliesTo(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("appliesTo").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest appliesTo() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("appliesTo"), Optional.empty());
    }

}
