package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppConsentRequest;
import odata.msgraph.client.beta.entity.collection.request.UserConsentRequestCollectionRequest;

@JsonIgnoreType
public class AppConsentRequestRequest extends EntityRequest<AppConsentRequest> {

    public AppConsentRequestRequest(ContextPath contextPath, Optional<Object> value) {
        super(AppConsentRequest.class, contextPath, value, false);
    }

    public UserConsentRequestRequest userConsentRequests(String id) {
        return new UserConsentRequestRequest(contextPath.addSegment("userConsentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserConsentRequestCollectionRequest userConsentRequests() {
        return new UserConsentRequestCollectionRequest(
                        contextPath.addSegment("userConsentRequests"), Optional.empty());
    }

}
