package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AppConsentApprovalRoute;
import odata.msgraph.client.beta.entity.collection.request.AppConsentRequestCollectionRequest;

@JsonIgnoreType
public class AppConsentApprovalRouteRequest extends EntityRequest<AppConsentApprovalRoute> {

    public AppConsentApprovalRouteRequest(ContextPath contextPath, Optional<Object> value) {
        super(AppConsentApprovalRoute.class, contextPath, value, false);
    }

    public AppConsentRequestRequest appConsentRequests(String id) {
        return new AppConsentRequestRequest(contextPath.addSegment("appConsentRequests").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AppConsentRequestCollectionRequest appConsentRequests() {
        return new AppConsentRequestCollectionRequest(
                        contextPath.addSegment("appConsentRequests"), Optional.empty());
    }

}
