package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AndroidManagedStoreAccountEnterpriseSettings;

@JsonIgnoreType
public class AndroidManagedStoreAccountEnterpriseSettingsRequest extends EntityRequest<AndroidManagedStoreAccountEnterpriseSettings> {

    public AndroidManagedStoreAccountEnterpriseSettingsRequest(ContextPath contextPath, Optional<Object> value) {
        super(AndroidManagedStoreAccountEnterpriseSettings.class, contextPath, value, false);
    }

    @Action(name = "approveApps")
    @JsonIgnore
    public ActionRequestNoReturn approveApps(List<String> packageIds, Boolean approveAllPermissions) {
        Preconditions.checkNotNull(approveAllPermissions, "approveAllPermissions cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("packageIds", "Collection(Edm.String)", Checks.checkIsAscii(packageIds))
            .put("approveAllPermissions", "Edm.Boolean", approveAllPermissions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.approveApps"), _parameters);
    }

    @Action(name = "completeSignup")
    @JsonIgnore
    public ActionRequestNoReturn completeSignup(String enterpriseToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enterpriseToken", "Edm.String", Checks.checkIsAscii(enterpriseToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeSignup"), _parameters);
    }

    @Action(name = "createGooglePlayWebToken")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createGooglePlayWebToken(String parentUri) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parentUri", "Edm.String", Checks.checkIsAscii(parentUri))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createGooglePlayWebToken"), String.class, _parameters);
    }

    @Action(name = "requestSignupUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> requestSignupUrl(String hostName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hostName", "Edm.String", Checks.checkIsAscii(hostName))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestSignupUrl"), String.class, _parameters);
    }

    @Action(name = "setAndroidDeviceOwnerFullyManagedEnrollmentState")
    @JsonIgnore
    public ActionRequestNoReturn setAndroidDeviceOwnerFullyManagedEnrollmentState(Boolean enabled) {
        Preconditions.checkNotNull(enabled, "enabled cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enabled", "Edm.Boolean", enabled)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setAndroidDeviceOwnerFullyManagedEnrollmentState"), _parameters);
    }

    @Action(name = "syncApps")
    @JsonIgnore
    public ActionRequestNoReturn syncApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncApps"), _parameters);
    }

    @Action(name = "unbind")
    @JsonIgnore
    public ActionRequestNoReturn unbind() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unbind"), _parameters);
    }

}
