package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerVpnConfiguration;

@JsonIgnoreType
public class AndroidDeviceOwnerVpnConfigurationRequest extends EntityRequest<AndroidDeviceOwnerVpnConfiguration> {

    public AndroidDeviceOwnerVpnConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(AndroidDeviceOwnerVpnConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

    public AndroidDeviceOwnerCertificateProfileBaseRequest identityCertificate() {
        return new AndroidDeviceOwnerCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), Optional.empty());
    }

}
