package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AndroidDeviceOwnerEnterpriseWiFiConfiguration;

@JsonIgnoreType
public class AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest extends EntityRequest<AndroidDeviceOwnerEnterpriseWiFiConfiguration> {

    public AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest(ContextPath contextPath, Optional<Object> value) {
        super(AndroidDeviceOwnerEnterpriseWiFiConfiguration.class, contextPath, value, false);
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"), Optional.empty());
    }

    public AndroidDeviceOwnerCertificateProfileBaseRequest identityCertificateForClientAuthentication() {
        return new AndroidDeviceOwnerCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"), Optional.empty());
    }

    public AndroidDeviceOwnerTrustedRootCertificateRequest rootCertificateForServerValidation() {
        return new AndroidDeviceOwnerTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"), Optional.empty());
    }

}
